/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndexV1;
import org.eclipse.jgit.internal.storage.file.PackIndexV2;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackIndex
implements Iterable<MutableEntry> {
    protected byte[] packChecksum;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackIndex open(File idxFile) throws IOException {
        PackIndex packIndex;
        FileInputStream fd = new FileInputStream(idxFile);
        try {
            try {
                packIndex = PackIndex.read(fd);
                Object var6_4 = null;
            }
            catch (IOException ioe) {
                String path2 = idxFile.getAbsolutePath();
                IOException err2 = new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, path2));
                err2.initCause(ioe);
                throw err2;
            }
        }
        catch (Throwable throwable2) {
            Object var6_5 = null;
            try {
                fd.close();
                throw throwable2;
            }
            catch (IOException err2) {
                throw throwable2;
            }
        }
        try {}
        catch (IOException err2) {
            // empty catch block
            return packIndex;
        }
        fd.close();
        return packIndex;
    }

    public static PackIndex read(InputStream fd) throws IOException, CorruptObjectException {
        byte[] hdr = new byte[8];
        IO.readFully(fd, hdr, 0, hdr.length);
        if (PackIndex.isTOC(hdr)) {
            int v = NB.decodeInt32(hdr, 4);
            switch (v) {
                case 2: {
                    return new PackIndexV2(fd);
                }
            }
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackIndexVersion, v));
        }
        return new PackIndexV1(fd, hdr);
    }

    private static boolean isTOC(byte[] h2) {
        byte[] toc = PackIndexWriter.TOC;
        for (int i = 0; i < toc.length; ++i) {
            if (h2[i] == toc[i]) continue;
            return false;
        }
        return true;
    }

    public boolean hasObject(AnyObjectId id) {
        return this.findOffset(id) != -1L;
    }

    @Override
    public abstract Iterator<MutableEntry> iterator();

    public abstract long getObjectCount();

    public abstract long getOffset64Count();

    public abstract ObjectId getObjectId(long var1);

    public final ObjectId getObjectId(int nthPosition) {
        if (nthPosition >= 0) {
            return this.getObjectId((long)nthPosition);
        }
        int u31 = nthPosition >>> 1;
        int one = nthPosition & 1;
        return this.getObjectId((long)u31 << 1 | (long)one);
    }

    abstract long getOffset(long var1);

    public abstract long findOffset(AnyObjectId var1);

    public abstract long findCRC32(AnyObjectId var1) throws MissingObjectException, UnsupportedOperationException;

    public abstract boolean hasCRC32Support();

    public abstract void resolve(Set<ObjectId> var1, AbbreviatedObjectId var2, int var3) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class EntriesIterator
    implements Iterator<MutableEntry> {
        protected final MutableEntry entry = this.initEntry();
        protected long returnedNumber = 0L;

        EntriesIterator() {
        }

        protected abstract MutableEntry initEntry();

        @Override
        public boolean hasNext() {
            return this.returnedNumber < PackIndex.this.getObjectCount();
        }

        @Override
        public abstract MutableEntry next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MutableEntry {
        final MutableObjectId idBuffer = new MutableObjectId();
        long offset;

        public long getOffset() {
            return this.offset;
        }

        public String name() {
            this.ensureId();
            return this.idBuffer.name();
        }

        public ObjectId toObjectId() {
            this.ensureId();
            return this.idBuffer.toObjectId();
        }

        public MutableEntry cloneEntry() {
            MutableEntry r = new MutableEntry();
            this.ensureId();
            r.idBuffer.fromObjectId(this.idBuffer);
            r.offset = this.offset;
            return r;
        }

        void ensureId() {
        }
    }
}

