/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.NB;

public final class PackOutputStream
extends OutputStream {
    private static final int BYTES_TO_WRITE_BEFORE_CANCEL_CHECK = 131072;
    private final ProgressMonitor writeMonitor;
    private final OutputStream out;
    private final PackWriter packWriter;
    private final MessageDigest md = Constants.newMessageDigest();
    private long count;
    private final byte[] headerBuffer = new byte[32];
    private final byte[] copyBuffer = new byte[65536];
    private long checkCancelAt;
    private boolean ofsDelta;

    public PackOutputStream(ProgressMonitor writeMonitor, OutputStream out, PackWriter pw) {
        this.writeMonitor = writeMonitor;
        this.out = out;
        this.packWriter = pw;
        this.checkCancelAt = 131072L;
    }

    public final void write(int b) throws IOException {
        ++this.count;
        this.out.write(b);
        this.md.update((byte)b);
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        while (0 < len) {
            int n = Math.min(len, 131072);
            this.count += (long)n;
            if (this.checkCancelAt <= this.count) {
                if (this.writeMonitor.isCancelled()) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                }
                this.checkCancelAt = this.count + 131072L;
            }
            this.out.write(b, off, n);
            this.md.update(b, off, n);
            off += n;
            len -= n;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    final void writeFileHeader(int version2, long objectCount) throws IOException {
        System.arraycopy(Constants.PACK_SIGNATURE, 0, this.headerBuffer, 0, 4);
        NB.encodeInt32(this.headerBuffer, 4, version2);
        NB.encodeInt32(this.headerBuffer, 8, (int)objectCount);
        this.write(this.headerBuffer, 0, 12);
        this.ofsDelta = this.packWriter.isDeltaBaseAsOffset();
    }

    public final void writeObject(ObjectToPack otp) throws IOException {
        this.packWriter.writeObject(this, otp);
    }

    public final void writeHeader(ObjectToPack otp, long rawLength) throws IOException {
        ObjectToPack b = otp.getDeltaBase();
        if (b != null && b.isWritten() & this.ofsDelta) {
            int n = PackOutputStream.objectHeader(rawLength, 6, this.headerBuffer);
            n = PackOutputStream.ofsDelta(this.count - b.getOffset(), this.headerBuffer, n);
            this.write(this.headerBuffer, 0, n);
        } else if (otp.isDeltaRepresentation()) {
            int n = PackOutputStream.objectHeader(rawLength, 7, this.headerBuffer);
            otp.getDeltaBaseId().copyRawTo(this.headerBuffer, n);
            this.write(this.headerBuffer, 0, n + 20);
        } else {
            int n = PackOutputStream.objectHeader(rawLength, otp.getType(), this.headerBuffer);
            this.write(this.headerBuffer, 0, n);
        }
    }

    private static final int objectHeader(long len, int type, byte[] buf) {
        byte b = (byte)((long)(type << 4) | len & 0xFL);
        int n = 0;
        len >>>= 4;
        while (len != 0L) {
            buf[n++] = (byte)(0x80 | b);
            b = (byte)(len & 0x7FL);
            len >>>= 7;
        }
        buf[n++] = b;
        return n;
    }

    private static final int ofsDelta(long diff2, byte[] buf, int p) {
        int n = p += PackOutputStream.ofsDeltaVarIntLength(diff2);
        buf[--n] = (byte)(diff2 & 0x7FL);
        while ((diff2 >>>= 7) != 0L) {
            buf[--n] = (byte)(0x80L | --diff2 & 0x7FL);
        }
        return p;
    }

    private static final int ofsDeltaVarIntLength(long v) {
        int n = 1;
        while ((v >>>= 7) != 0L) {
            --v;
            ++n;
        }
        return n;
    }

    public final byte[] getCopyBuffer() {
        return this.copyBuffer;
    }

    void endObject() {
        this.writeMonitor.update(1);
    }

    public final long length() {
        return this.count;
    }

    final byte[] getDigest() {
        return this.md.digest();
    }
}

