/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.resolver;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResolver<C>
implements RepositoryResolver<C> {
    private volatile boolean exportAll;
    private final Map<String, Repository> exports = new ConcurrentHashMap<String, Repository>();
    private final Collection<File> exportBase = new CopyOnWriteArrayList<File>();

    public FileResolver() {
    }

    public FileResolver(File basePath, boolean exportAll) {
        this();
        this.exportDirectory(basePath);
        this.setExportAll(exportAll);
    }

    @Override
    public Repository open(C req, String name2) throws RepositoryNotFoundException, ServiceNotEnabledException {
        if (FileResolver.isUnreasonableName(name2)) {
            throw new RepositoryNotFoundException(name2);
        }
        Repository db = this.exports.get(FileResolver.nameWithDotGit(name2));
        if (db != null) {
            db.incrementOpen();
            return db;
        }
        for (File base : this.exportBase) {
            File dir = RepositoryCache.FileKey.resolve(new File(base, name2), FS.DETECTED);
            if (dir == null) continue;
            try {
                RepositoryCache.FileKey key = RepositoryCache.FileKey.exact(dir, FS.DETECTED);
                db = RepositoryCache.open(key, true);
            }
            catch (IOException e) {
                throw new RepositoryNotFoundException(name2, (Throwable)e);
            }
            try {
                if (this.isExportOk(req, name2, db)) {
                    return db;
                }
                throw new ServiceNotEnabledException();
            }
            catch (RuntimeException e) {
                db.close();
                throw new RepositoryNotFoundException(name2, (Throwable)e);
            }
            catch (IOException e) {
                db.close();
                throw new RepositoryNotFoundException(name2, (Throwable)e);
            }
            catch (ServiceNotEnabledException e) {
                db.close();
                throw e;
            }
        }
        if (this.exportBase.size() == 1) {
            File dir = new File(this.exportBase.iterator().next(), name2);
            throw new RepositoryNotFoundException(name2, (Throwable)new RepositoryNotFoundException(dir));
        }
        throw new RepositoryNotFoundException(name2);
    }

    public boolean isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(boolean export) {
        this.exportAll = export;
    }

    public void exportRepository(String name2, Repository db) {
        this.exports.put(FileResolver.nameWithDotGit(name2), db);
    }

    public void exportDirectory(File dir) {
        this.exportBase.add(dir);
    }

    protected boolean isExportOk(C req, String repositoryName, Repository db) throws IOException {
        if (this.isExportAll()) {
            return true;
        }
        if (db.getDirectory() != null) {
            return new File(db.getDirectory(), "git-daemon-export-ok").exists();
        }
        return false;
    }

    private static String nameWithDotGit(String name2) {
        if (name2.endsWith(".git")) {
            return name2;
        }
        return name2 + ".git";
    }

    private static boolean isUnreasonableName(String name2) {
        if (name2.length() == 0) {
            return true;
        }
        if (name2.indexOf(92) >= 0) {
            return true;
        }
        if (new File(name2).isAbsolute()) {
            return true;
        }
        if (name2.startsWith("../")) {
            return true;
        }
        if (name2.contains("/../")) {
            return true;
        }
        if (name2.contains("/./")) {
            return true;
        }
        return name2.contains("//");
    }
}

