/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import java.io.IOException;

public abstract class ValueInstantiator {
    public abstract String getValueTypeDesc();

    public boolean canInstantiate() {
        return this.canCreateUsingDefault() || this.canCreateUsingDelegate() || this.canCreateFromObjectWith() || this.canCreateFromString() || this.canCreateFromInt() || this.canCreateFromLong() || this.canCreateFromDouble() || this.canCreateFromBoolean();
    }

    public boolean canCreateFromString() {
        return false;
    }

    public boolean canCreateFromInt() {
        return false;
    }

    public boolean canCreateFromLong() {
        return false;
    }

    public boolean canCreateFromDouble() {
        return false;
    }

    public boolean canCreateFromBoolean() {
        return false;
    }

    public boolean canCreateUsingDefault() {
        return this.getDefaultCreator() != null;
    }

    public boolean canCreateUsingDelegate() {
        return false;
    }

    public boolean canCreateUsingArrayDelegate() {
        return false;
    }

    public boolean canCreateFromObjectWith() {
        return false;
    }

    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        return null;
    }

    public JavaType getDelegateType(DeserializationConfig config) {
        return null;
    }

    public JavaType getArrayDelegateType(DeserializationConfig config) {
        return null;
    }

    public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
        throw ctxt.mappingException("Can not instantiate value of type %s; no default creator found", this.getValueTypeDesc());
    }

    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args2) throws IOException {
        throw ctxt.mappingException("Can not instantiate value of type %s with arguments", this.getValueTypeDesc());
    }

    public Object createUsingDelegate(DeserializationContext ctxt, Object delegate) throws IOException {
        throw ctxt.mappingException("Can not instantiate value of type %s using delegate", this.getValueTypeDesc());
    }

    public Object createUsingArrayDelegate(DeserializationContext ctxt, Object delegate) throws IOException {
        throw ctxt.mappingException("Can not instantiate value of type %s using delegate", this.getValueTypeDesc());
    }

    public Object createFromString(DeserializationContext ctxt, String value2) throws IOException {
        return this._createFromStringFallbacks(ctxt, value2);
    }

    public Object createFromInt(DeserializationContext ctxt, int value2) throws IOException {
        throw ctxt.mappingException("Can not instantiate value of type %s from Integer number (%s, int)", this.getValueTypeDesc(), value2);
    }

    public Object createFromLong(DeserializationContext ctxt, long value2) throws IOException {
        throw ctxt.mappingException("Can not instantiate value of type %s from Integer number (%s, long)", this.getValueTypeDesc(), value2);
    }

    public Object createFromDouble(DeserializationContext ctxt, double value2) throws IOException {
        throw ctxt.mappingException("Can not instantiate value of type %s from Floating-point number (%s, double)", this.getValueTypeDesc(), value2);
    }

    public Object createFromBoolean(DeserializationContext ctxt, boolean value2) throws IOException {
        throw ctxt.mappingException("Can not instantiate value of type %s from Boolean value (%s)", this.getValueTypeDesc(), value2);
    }

    public AnnotatedWithParams getDefaultCreator() {
        return null;
    }

    public AnnotatedWithParams getDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getArrayDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getWithArgsCreator() {
        return null;
    }

    public AnnotatedParameter getIncompleteParameter() {
        return null;
    }

    protected Object _createFromStringFallbacks(DeserializationContext ctxt, String value2) throws IOException, JsonProcessingException {
        if (this.canCreateFromBoolean()) {
            String str = value2.trim();
            if ("true".equals(str)) {
                return this.createFromBoolean(ctxt, true);
            }
            if ("false".equals(str)) {
                return this.createFromBoolean(ctxt, false);
            }
        }
        if (value2.length() == 0 && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
            return null;
        }
        throw ctxt.mappingException("Can not instantiate value of type %s from String value ('%s'); no single-String constructor/factory method", this.getValueTypeDesc(), value2);
    }
}

