/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SimpleConfig;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigBeanImpl {
    public static <T> T createInternal(Config config, Class<T> clazz2) {
        if (((SimpleConfig)config).root().resolveStatus() != ResolveStatus.RESOLVED) {
            throw new ConfigException.NotResolved("need to Config#resolve() a config before using it to initialize a bean, see the API docs for Config#resolve()");
        }
        HashMap<String, AbstractConfigValue> configProps = new HashMap<String, AbstractConfigValue>();
        HashMap<String, PropertyDescriptor[]> originalNames = new HashMap<String, PropertyDescriptor[]>();
        for (Map.Entry configProp : config.root().entrySet()) {
            PropertyDescriptor[] originalName = (PropertyDescriptor[])configProp.getKey();
            String camelName = ConfigImplUtil.toCamelCase((String)originalName);
            if (originalNames.containsKey(camelName) && !originalName.equals(camelName)) continue;
            configProps.put(camelName, (AbstractConfigValue)configProp.getValue());
            originalNames.put(camelName, originalName);
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz2);
        }
        catch (IntrospectionException e) {
            throw new ConfigException.BadBean("Could not get bean information for class " + clazz2.getName(), e);
        }
        try {
            ArrayList<PropertyDescriptor> beanProps = new ArrayList<PropertyDescriptor>();
            for (PropertyDescriptor beanProp : beanInfo.getPropertyDescriptors()) {
                if (beanProp.getReadMethod() == null || beanProp.getWriteMethod() == null) continue;
                beanProps.add(beanProp);
            }
            ArrayList<ConfigException.ValidationProblem> problems = new ArrayList<ConfigException.ValidationProblem>();
            for (PropertyDescriptor beanProp : beanProps) {
                Method setter2 = beanProp.getWriteMethod();
                Class<?> parameterClass = setter2.getParameterTypes()[0];
                ConfigValueType expectedType = ConfigBeanImpl.getValueTypeOrNull(parameterClass);
                if (expectedType == null) continue;
                String name2 = (String)originalNames.get(beanProp.getName());
                if (name2 == null) {
                    name2 = beanProp.getName();
                }
                Path path2 = Path.newKey(name2);
                AbstractConfigValue configValue = (AbstractConfigValue)configProps.get(beanProp.getName());
                if (configValue != null) {
                    SimpleConfig.checkValid(path2, expectedType, configValue, problems);
                    continue;
                }
                SimpleConfig.addMissing(problems, expectedType, path2, config.origin());
            }
            if (!problems.isEmpty()) {
                throw new ConfigException.ValidationFailed(problems);
            }
            T bean = clazz2.newInstance();
            for (PropertyDescriptor beanProp : beanProps) {
                Method setter3 = beanProp.getWriteMethod();
                Type parameterType = setter3.getGenericParameterTypes()[0];
                Class<?> parameterClass = setter3.getParameterTypes()[0];
                Object unwrapped = ConfigBeanImpl.getValue(clazz2, parameterType, parameterClass, config, (String)originalNames.get(beanProp.getName()));
                setter3.invoke(bean, unwrapped);
            }
            return bean;
        }
        catch (InstantiationException e) {
            throw new ConfigException.BadBean(clazz2.getName() + " needs a public no-args constructor to be used as a bean", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigException.BadBean(clazz2.getName() + " getters and setters are not accessible, they must be for use as a bean", e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigException.BadBean("Calling bean method on " + clazz2.getName() + " caused an exception", e);
        }
    }

    private static Object getValue(Class<?> beanClass, Type parameterType, Class<?> parameterClass, Config config, String configPropName) {
        if (parameterClass == Boolean.class || parameterClass == Boolean.TYPE) {
            return config.getBoolean(configPropName);
        }
        if (parameterClass == Integer.class || parameterClass == Integer.TYPE) {
            return config.getInt(configPropName);
        }
        if (parameterClass == Double.class || parameterClass == Double.TYPE) {
            return config.getDouble(configPropName);
        }
        if (parameterClass == Long.class || parameterClass == Long.TYPE) {
            return config.getLong(configPropName);
        }
        if (parameterClass == String.class) {
            return config.getString(configPropName);
        }
        if (parameterClass == Duration.class) {
            return config.getDuration(configPropName);
        }
        if (parameterClass == ConfigMemorySize.class) {
            return config.getMemorySize(configPropName);
        }
        if (parameterClass == Object.class) {
            return config.getAnyRef(configPropName);
        }
        if (parameterClass == List.class) {
            return ConfigBeanImpl.getListValue(beanClass, parameterType, parameterClass, config, configPropName);
        }
        if (parameterClass == Map.class) {
            Type[] typeArgs2 = ((ParameterizedType)parameterType).getActualTypeArguments();
            if (typeArgs2[0] != String.class || typeArgs2[1] != Object.class) {
                throw new ConfigException.BadBean("Bean property '" + configPropName + "' of class " + beanClass.getName() + " has unsupported Map<" + typeArgs2[0] + "," + typeArgs2[1] + ">, only Map<String,Object> is supported right now");
            }
            return config.getObject(configPropName).unwrapped();
        }
        if (parameterClass == Config.class) {
            return config.getConfig(configPropName);
        }
        if (parameterClass == ConfigObject.class) {
            return config.getObject(configPropName);
        }
        if (parameterClass == ConfigValue.class) {
            return config.getValue(configPropName);
        }
        if (parameterClass == ConfigList.class) {
            return config.getList(configPropName);
        }
        if (ConfigBeanImpl.hasAtLeastOneBeanProperty(parameterClass)) {
            return ConfigBeanImpl.createInternal(config.getConfig(configPropName), parameterClass);
        }
        throw new ConfigException.BadBean("Bean property " + configPropName + " of class " + beanClass.getName() + " has unsupported type " + parameterType);
    }

    private static Object getListValue(Class<?> beanClass, Type parameterType, Class<?> parameterClass, Config config, String configPropName) {
        Type elementType2 = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
        if (elementType2 == Boolean.class) {
            return config.getBooleanList(configPropName);
        }
        if (elementType2 == Integer.class) {
            return config.getIntList(configPropName);
        }
        if (elementType2 == Double.class) {
            return config.getDoubleList(configPropName);
        }
        if (elementType2 == Long.class) {
            return config.getLongList(configPropName);
        }
        if (elementType2 == String.class) {
            return config.getStringList(configPropName);
        }
        if (elementType2 == Duration.class) {
            return config.getDurationList(configPropName);
        }
        if (elementType2 == ConfigMemorySize.class) {
            return config.getMemorySizeList(configPropName);
        }
        if (elementType2 == Object.class) {
            return config.getAnyRefList(configPropName);
        }
        if (elementType2 == Config.class) {
            return config.getConfigList(configPropName);
        }
        if (elementType2 == ConfigObject.class) {
            return config.getObjectList(configPropName);
        }
        if (elementType2 == ConfigValue.class) {
            return config.getList(configPropName);
        }
        throw new ConfigException.BadBean("Bean property '" + configPropName + "' of class " + beanClass.getName() + " has unsupported list element type " + elementType2);
    }

    private static ConfigValueType getValueTypeOrNull(Class<?> parameterClass) {
        if (parameterClass == Boolean.class || parameterClass == Boolean.TYPE) {
            return ConfigValueType.BOOLEAN;
        }
        if (parameterClass == Integer.class || parameterClass == Integer.TYPE) {
            return ConfigValueType.NUMBER;
        }
        if (parameterClass == Double.class || parameterClass == Double.TYPE) {
            return ConfigValueType.NUMBER;
        }
        if (parameterClass == Long.class || parameterClass == Long.TYPE) {
            return ConfigValueType.NUMBER;
        }
        if (parameterClass == String.class) {
            return ConfigValueType.STRING;
        }
        if (parameterClass == Duration.class) {
            return null;
        }
        if (parameterClass == ConfigMemorySize.class) {
            return null;
        }
        if (parameterClass == List.class) {
            return ConfigValueType.LIST;
        }
        if (parameterClass == Map.class) {
            return ConfigValueType.OBJECT;
        }
        if (parameterClass == Config.class) {
            return ConfigValueType.OBJECT;
        }
        if (parameterClass == ConfigObject.class) {
            return ConfigValueType.OBJECT;
        }
        if (parameterClass == ConfigList.class) {
            return ConfigValueType.LIST;
        }
        return null;
    }

    private static boolean hasAtLeastOneBeanProperty(Class<?> clazz2) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz2);
        }
        catch (IntrospectionException e) {
            return false;
        }
        for (PropertyDescriptor beanProp : beanInfo.getPropertyDescriptors()) {
            if (beanProp.getReadMethod() == null || beanProp.getWriteMethod() == null) continue;
            return true;
        }
        return false;
    }
}

