/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.message.LineFormatter;
import org.apache.http.util.CharArrayBuffer;

public class BasicLineFormatter
implements LineFormatter {
    public static final BasicLineFormatter DEFAULT = new BasicLineFormatter();

    protected CharArrayBuffer initBuffer(CharArrayBuffer buffer2) {
        if (buffer2 != null) {
            buffer2.clear();
        } else {
            buffer2 = new CharArrayBuffer(64);
        }
        return buffer2;
    }

    public static final String formatProtocolVersion(ProtocolVersion version2, LineFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.appendProtocolVersion(null, version2).toString();
    }

    public CharArrayBuffer appendProtocolVersion(CharArrayBuffer buffer2, ProtocolVersion version2) {
        if (version2 == null) {
            throw new IllegalArgumentException("Protocol version may not be null");
        }
        CharArrayBuffer result2 = buffer2;
        int len = this.estimateProtocolVersionLen(version2);
        if (result2 == null) {
            result2 = new CharArrayBuffer(len);
        } else {
            result2.ensureCapacity(len);
        }
        result2.append(version2.getProtocol());
        result2.append('/');
        result2.append(Integer.toString(version2.getMajor()));
        result2.append('.');
        result2.append(Integer.toString(version2.getMinor()));
        return result2;
    }

    protected int estimateProtocolVersionLen(ProtocolVersion version2) {
        return version2.getProtocol().length() + 4;
    }

    public static final String formatRequestLine(RequestLine reqline, LineFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatRequestLine(null, reqline).toString();
    }

    public CharArrayBuffer formatRequestLine(CharArrayBuffer buffer2, RequestLine reqline) {
        if (reqline == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        CharArrayBuffer result2 = this.initBuffer(buffer2);
        this.doFormatRequestLine(result2, reqline);
        return result2;
    }

    protected void doFormatRequestLine(CharArrayBuffer buffer2, RequestLine reqline) {
        String method = reqline.getMethod();
        String uri = reqline.getUri();
        int len = method.length() + 1 + uri.length() + 1 + this.estimateProtocolVersionLen(reqline.getProtocolVersion());
        buffer2.ensureCapacity(len);
        buffer2.append(method);
        buffer2.append(' ');
        buffer2.append(uri);
        buffer2.append(' ');
        this.appendProtocolVersion(buffer2, reqline.getProtocolVersion());
    }

    public static final String formatStatusLine(StatusLine statline, LineFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatStatusLine(null, statline).toString();
    }

    public CharArrayBuffer formatStatusLine(CharArrayBuffer buffer2, StatusLine statline) {
        if (statline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        CharArrayBuffer result2 = this.initBuffer(buffer2);
        this.doFormatStatusLine(result2, statline);
        return result2;
    }

    protected void doFormatStatusLine(CharArrayBuffer buffer2, StatusLine statline) {
        int len = this.estimateProtocolVersionLen(statline.getProtocolVersion()) + 1 + 3 + 1;
        String reason = statline.getReasonPhrase();
        if (reason != null) {
            len += reason.length();
        }
        buffer2.ensureCapacity(len);
        this.appendProtocolVersion(buffer2, statline.getProtocolVersion());
        buffer2.append(' ');
        buffer2.append(Integer.toString(statline.getStatusCode()));
        buffer2.append(' ');
        if (reason != null) {
            buffer2.append(reason);
        }
    }

    public static final String formatHeader(Header header2, LineFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatHeader(null, header2).toString();
    }

    public CharArrayBuffer formatHeader(CharArrayBuffer buffer2, Header header2) {
        if (header2 == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        CharArrayBuffer result2 = null;
        if (header2 instanceof FormattedHeader) {
            result2 = ((FormattedHeader)header2).getBuffer();
        } else {
            result2 = this.initBuffer(buffer2);
            this.doFormatHeader(result2, header2);
        }
        return result2;
    }

    protected void doFormatHeader(CharArrayBuffer buffer2, Header header2) {
        String name2 = header2.getName();
        String value2 = header2.getValue();
        int len = name2.length() + 2;
        if (value2 != null) {
            len += value2.length();
        }
        buffer2.ensureCapacity(len);
        buffer2.append(name2);
        buffer2.append(": ");
        if (value2 != null) {
            buffer2.append(value2);
        }
    }
}

