/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.Map;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.UriPatternMatcher;

public class HttpRequestHandlerRegistry
implements HttpRequestHandlerResolver {
    private final UriPatternMatcher matcher = new UriPatternMatcher();

    public void register(String pattern2, HttpRequestHandler handler) {
        if (pattern2 == null) {
            throw new IllegalArgumentException("URI request pattern may not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Request handler may not be null");
        }
        this.matcher.register(pattern2, handler);
    }

    public void unregister(String pattern2) {
        this.matcher.unregister(pattern2);
    }

    public void setHandlers(Map map2) {
        this.matcher.setObjects(map2);
    }

    public HttpRequestHandler lookup(String requestURI) {
        return (HttpRequestHandler)this.matcher.lookup(requestURI);
    }

    protected boolean matchUriRequestPattern(String pattern2, String requestUri) {
        return this.matcher.matchUriRequestPattern(pattern2, requestUri);
    }
}

