/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.dircache.InvalidPathException;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.AutoCRLFOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirCacheCheckout {
    private Repository repo;
    private HashMap<String, ObjectId> updated = new HashMap();
    private ArrayList<String> conflicts = new ArrayList();
    private ArrayList<String> removed = new ArrayList();
    private ObjectId mergeCommitTree;
    private DirCache dc;
    private DirCacheBuilder builder;
    private NameConflictTreeWalk walk;
    private ObjectId headCommitTree;
    private WorkingTreeIterator workingTree;
    private boolean failOnConflict = true;
    private ArrayList<String> toBeDeleted = new ArrayList();
    private boolean emptyDirCache;

    public Map<String, ObjectId> getUpdated() {
        return this.updated;
    }

    public List<String> getConflicts() {
        return this.conflicts;
    }

    public List<String> getToBeDeleted() {
        return this.toBeDeleted;
    }

    public List<String> getRemoved() {
        return this.removed;
    }

    public DirCacheCheckout(Repository repo, ObjectId headCommitTree, DirCache dc, ObjectId mergeCommitTree, WorkingTreeIterator workingTree) throws IOException {
        this.repo = repo;
        this.dc = dc;
        this.headCommitTree = headCommitTree;
        this.mergeCommitTree = mergeCommitTree;
        this.workingTree = workingTree;
        this.emptyDirCache = dc == null || dc.getEntryCount() == 0;
    }

    public DirCacheCheckout(Repository repo, ObjectId headCommitTree, DirCache dc, ObjectId mergeCommitTree) throws IOException {
        this(repo, headCommitTree, dc, mergeCommitTree, new FileTreeIterator(repo));
    }

    public DirCacheCheckout(Repository repo, DirCache dc, ObjectId mergeCommitTree, WorkingTreeIterator workingTree) throws IOException {
        this(repo, null, dc, mergeCommitTree, workingTree);
    }

    public DirCacheCheckout(Repository repo, DirCache dc, ObjectId mergeCommitTree) throws IOException {
        this(repo, null, dc, mergeCommitTree, new FileTreeIterator(repo));
    }

    public void preScanTwoTrees() throws CorruptObjectException, IOException {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.builder = this.dc.builder();
        this.addTree(this.walk, this.headCommitTree);
        this.addTree(this.walk, this.mergeCommitTree);
        this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        while (this.walk.next()) {
            this.processEntry(this.walk.getTree(0, CanonicalTreeParser.class), this.walk.getTree(1, CanonicalTreeParser.class), this.walk.getTree(2, DirCacheBuildIterator.class), this.walk.getTree(3, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
    }

    private void addTree(TreeWalk tw, ObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (id == null) {
            tw.addTree(new EmptyTreeIterator());
        } else {
            tw.addTree(id);
        }
    }

    public void prescanOneTree() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.builder = this.dc.builder();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.addTree(this.walk, this.mergeCommitTree);
        this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        while (this.walk.next()) {
            this.processEntry(this.walk.getTree(0, CanonicalTreeParser.class), this.walk.getTree(1, DirCacheBuildIterator.class), this.walk.getTree(2, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
        this.conflicts.removeAll(this.removed);
    }

    void processEntry(CanonicalTreeParser m, DirCacheBuildIterator i, WorkingTreeIterator f2) throws IOException {
        if (m != null) {
            DirCacheCheckout.checkValidPath(m);
            if (i == null) {
                if (f2 != null && !FileMode.TREE.equals(f2.getEntryFileMode()) && !f2.isEntryIgnored()) {
                    this.conflicts.add(this.walk.getPathString());
                } else {
                    this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
                }
            } else if (f2 == null || !m.idEqual(i)) {
                this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
            } else if (i.getDirCacheEntry() != null) {
                if (f2.isModified(i.getDirCacheEntry(), true, this.walk.getObjectReader()) || i.getDirCacheEntry().getStage() != 0) {
                    this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
                } else {
                    DirCacheEntry entry2 = i.getDirCacheEntry();
                    if (entry2.getLastModified() == 0L) {
                        entry2.setLastModified(f2.getEntryLastModified());
                    }
                    this.keep(entry2);
                }
            } else {
                this.keep(i.getDirCacheEntry());
            }
        } else if (f2 != null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflicts.add(this.walk.getPathString());
            } else if (i != null) {
                this.remove(i.getEntryPathString());
                this.conflicts.remove(i.getEntryPathString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout() throws IOException {
        try {
            boolean bl = this.doCheckout();
            Object var3_2 = null;
            this.dc.unlock();
            return bl;
        }
        catch (Throwable throwable2) {
            Object var3_3 = null;
            this.dc.unlock();
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckout() throws CorruptObjectException, IOException, MissingObjectException, IncorrectObjectTypeException, CheckoutConflictException, IndexWriteException {
        this.toBeDeleted.clear();
        ObjectReader objectReader = this.repo.getObjectDatabase().newReader();
        try {
            if (this.headCommitTree != null) {
                this.preScanTwoTrees();
            } else {
                this.prescanOneTree();
            }
            if (!this.conflicts.isEmpty()) {
                if (this.failOnConflict) {
                    throw new CheckoutConflictException(this.conflicts.toArray(new String[this.conflicts.size()]));
                }
                this.cleanUpConflicts();
            }
            this.builder.finish();
            File file = null;
            String last2 = null;
            for (int i = this.removed.size() - 1; i >= 0; --i) {
                String r = this.removed.get(i);
                file = new File(this.repo.getWorkTree(), r);
                if (!file.delete() && this.repo.getFS().exists(file)) {
                    if (this.repo.getFS().isDirectory(file)) continue;
                    this.toBeDeleted.add(r);
                    continue;
                }
                if (last2 != null && !DirCacheCheckout.isSamePrefix(r, last2)) {
                    this.removeEmptyParents(new File(this.repo.getWorkTree(), last2));
                }
                last2 = r;
            }
            if (file != null) {
                this.removeEmptyParents(file);
            }
            for (String path2 : this.updated.keySet()) {
                DirCacheEntry entry2 = this.dc.getEntry(path2);
                if (FileMode.GITLINK.equals(entry2.getRawMode())) continue;
                DirCacheCheckout.checkoutEntry(this.repo, entry2, objectReader);
            }
            if (!this.builder.commit()) {
                throw new IndexWriteException();
            }
            Object var8_8 = null;
            objectReader.release();
        }
        catch (Throwable throwable2) {
            Object var8_9 = null;
            objectReader.release();
            throw throwable2;
        }
        return this.toBeDeleted.size() == 0;
    }

    private static boolean isSamePrefix(String a, String b) {
        int as2 = a.lastIndexOf(47);
        int bs = b.lastIndexOf(47);
        return a.substring(0, as2 + 1).equals(b.substring(0, bs + 1));
    }

    private void removeEmptyParents(File f2) {
        for (File parentFile = f2.getParentFile(); parentFile != null && !parentFile.equals(this.repo.getWorkTree()) && parentFile.delete(); parentFile = parentFile.getParentFile()) {
        }
    }

    private boolean equalIdAndMode(ObjectId id1, FileMode mode1, ObjectId id2, FileMode mode2) {
        if (!mode1.equals(mode2)) {
            return false;
        }
        return id1 != null ? id1.equals(id2) : id2 == null;
    }

    void processEntry(CanonicalTreeParser h2, CanonicalTreeParser m, DirCacheBuildIterator i, WorkingTreeIterator f2) throws IOException {
        DirCacheEntry dce = i != null ? i.getDirCacheEntry() : null;
        String name2 = this.walk.getPathString();
        if (m != null) {
            DirCacheCheckout.checkValidPath(m);
        }
        if (i == null && m == null && h2 == null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflict(name2, null, null, null);
            }
            return;
        }
        ObjectId iId = i == null ? null : i.getEntryObjectId();
        ObjectId mId = m == null ? null : m.getEntryObjectId();
        ObjectId hId = h2 == null ? null : h2.getEntryObjectId();
        FileMode iMode = i == null ? null : i.getEntryFileMode();
        FileMode mMode = m == null ? null : m.getEntryFileMode();
        FileMode hMode = h2 == null ? null : h2.getEntryFileMode();
        int ffMask = 0;
        if (h2 != null) {
            int n = ffMask = FileMode.TREE.equals(hMode) ? 3328 : 3840;
        }
        if (i != null) {
            ffMask |= FileMode.TREE.equals(iMode) ? 208 : 240;
        }
        if (m != null) {
            ffMask |= FileMode.TREE.equals(mMode) ? 13 : 15;
        }
        if ((ffMask & 0x222) != 0 && ((ffMask & 0xF) == 13 || (ffMask & 0xF0) == 208 || (ffMask & 0xF00) == 3328)) {
            switch (ffMask) {
                case 3551: {
                    if (f2 != null && this.isModifiedSubtree_IndexWorkingtree(name2)) {
                        this.conflict(name2, dce, h2, m);
                        break;
                    }
                    this.update(name2, mId, mMode);
                    break;
                }
                case 3581: {
                    this.keep(dce);
                    break;
                }
                case 3853: {
                    this.remove(name2);
                    break;
                }
                case 3583: {
                    if (this.equalIdAndMode(iId, iMode, mId, mMode)) {
                        this.keep(dce);
                        break;
                    }
                    this.conflict(name2, dce, h2, m);
                    break;
                }
                case 4061: {
                    break;
                }
                case 3343: {
                    this.update(name2, mId, mMode);
                    break;
                }
                case 253: 
                case 3568: {
                    this.conflict(name2, dce, h2, m);
                    break;
                }
                case 4063: {
                    if (this.equalIdAndMode(hId, hMode, mId, mMode)) {
                        if (this.isModifiedSubtree_IndexWorkingtree(name2)) {
                            this.conflict(name2, dce, h2, m);
                            break;
                        }
                        this.update(name2, mId, mMode);
                        break;
                    }
                    this.conflict(name2, dce, h2, m);
                    break;
                }
                case 4048: {
                    this.keep(dce);
                    break;
                }
                case 4093: {
                    if (this.equalIdAndMode(hId, hMode, iId, iMode)) {
                        if (f2 != null && f2.isModified(dce, true, this.walk.getObjectReader())) {
                            this.conflict(name2, dce, h2, m);
                            break;
                        }
                        this.remove(name2);
                        break;
                    }
                    this.conflict(name2, dce, h2, m);
                    break;
                }
                case 223: {
                    if (!this.isModifiedSubtree_IndexWorkingtree(name2)) {
                        this.update(name2, mId, mMode);
                        break;
                    }
                    this.conflict(name2, dce, h2, m);
                    break;
                }
                default: {
                    this.keep(dce);
                }
            }
            return;
        }
        if ((ffMask & 0x222) == 0 && (f2 == null || FileMode.TREE.equals(f2.getEntryFileMode()))) {
            return;
        }
        if (ffMask == 15 && f2 != null && FileMode.TREE.equals(f2.getEntryFileMode())) {
            this.conflict(name2, null, h2, m);
            return;
        }
        if (i == null) {
            if (!(f2 == null || f2.isEntryIgnored() || FileMode.GITLINK.equals(mMode) || mId != null && this.equalIdAndMode(mId, mMode, f2.getEntryObjectId(), f2.getEntryFileMode()))) {
                this.conflict(name2, null, h2, m);
                return;
            }
            if (h2 == null) {
                this.update(name2, mId, mMode);
            } else if (m == null) {
                this.remove(name2);
            } else if (this.equalIdAndMode(hId, hMode, mId, mMode)) {
                if (this.emptyDirCache) {
                    this.update(name2, mId, mMode);
                } else {
                    this.keep(dce);
                }
            } else {
                this.conflict(name2, dce, h2, m);
            }
        } else if (h2 == null) {
            if (m == null || !this.isModified_IndexTree(name2, iId, iMode, mId, mMode, this.mergeCommitTree)) {
                if (m == null && this.walk.isDirectoryFileConflict()) {
                    if (dce != null && (f2 == null || f2.isModified(dce, true, this.walk.getObjectReader()))) {
                        this.conflict(name2, dce, h2, m);
                    } else {
                        this.remove(name2);
                    }
                } else {
                    this.keep(dce);
                }
            } else {
                this.conflict(name2, dce, h2, m);
            }
        } else if (m == null) {
            if (iMode == FileMode.GITLINK) {
                this.remove(name2);
            } else if (!this.isModified_IndexTree(name2, iId, iMode, hId, hMode, this.headCommitTree)) {
                if (f2 != null && f2.isModified(dce, true, this.walk.getObjectReader())) {
                    if (!FileMode.TREE.equals(f2.getEntryFileMode()) && FileMode.TREE.equals(iMode)) {
                        return;
                    }
                    this.conflict(name2, dce, h2, m);
                } else {
                    this.remove(name2);
                }
            } else {
                this.conflict(name2, dce, h2, m);
            }
        } else if (!this.equalIdAndMode(hId, hMode, mId, mMode) && this.isModified_IndexTree(name2, iId, iMode, hId, hMode, this.headCommitTree) && this.isModified_IndexTree(name2, iId, iMode, mId, mMode, this.mergeCommitTree)) {
            this.conflict(name2, dce, h2, m);
        } else if (!this.isModified_IndexTree(name2, iId, iMode, hId, hMode, this.headCommitTree) && this.isModified_IndexTree(name2, iId, iMode, mId, mMode, this.mergeCommitTree)) {
            if (dce != null && FileMode.GITLINK.equals(dce.getFileMode())) {
                this.update(name2, mId, mMode);
            } else if (dce != null && f2 != null && f2.isModified(dce, true, this.walk.getObjectReader())) {
                this.conflict(name2, dce, h2, m);
            } else {
                this.update(name2, mId, mMode);
            }
        } else {
            this.keep(dce);
        }
    }

    private void conflict(String path2, DirCacheEntry e, AbstractTreeIterator h2, AbstractTreeIterator m) {
        DirCacheEntry entry2;
        this.conflicts.add(path2);
        if (e != null) {
            entry2 = new DirCacheEntry(e.getPathString(), 1);
            entry2.copyMetaData(e, true);
            this.builder.add(entry2);
        }
        if (h2 != null && !FileMode.TREE.equals(h2.getEntryFileMode())) {
            entry2 = new DirCacheEntry(h2.getEntryPathString(), 2);
            entry2.setFileMode(h2.getEntryFileMode());
            entry2.setObjectId(h2.getEntryObjectId());
            this.builder.add(entry2);
        }
        if (m != null && !FileMode.TREE.equals(m.getEntryFileMode())) {
            entry2 = new DirCacheEntry(m.getEntryPathString(), 3);
            entry2.setFileMode(m.getEntryFileMode());
            entry2.setObjectId(m.getEntryObjectId());
            this.builder.add(entry2);
        }
    }

    private void keep(DirCacheEntry e) {
        if (e != null && !FileMode.TREE.equals(e.getFileMode())) {
            this.builder.add(e);
        }
    }

    private void remove(String path2) {
        this.removed.add(path2);
    }

    private void update(String path2, ObjectId mId, FileMode mode) {
        if (!FileMode.TREE.equals(mode)) {
            this.updated.put(path2, mId);
            DirCacheEntry entry2 = new DirCacheEntry(path2, 0);
            entry2.setObjectId(mId);
            entry2.setFileMode(mode);
            this.builder.add(entry2);
        }
    }

    public void setFailOnConflict(boolean failOnConflict) {
        this.failOnConflict = failOnConflict;
    }

    private void cleanUpConflicts() throws CheckoutConflictException {
        for (String c : this.conflicts) {
            File conflict = new File(this.repo.getWorkTree(), c);
            if (!conflict.delete()) {
                throw new CheckoutConflictException(MessageFormat.format(JGitText.get().cannotDeleteFile, c));
            }
            this.removeEmptyParents(conflict);
        }
        for (String r : this.removed) {
            File file = new File(this.repo.getWorkTree(), r);
            if (!file.delete()) {
                throw new CheckoutConflictException(MessageFormat.format(JGitText.get().cannotDeleteFile, file.getAbsolutePath()));
            }
            this.removeEmptyParents(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isModifiedSubtree_IndexWorkingtree(String path2) throws CorruptObjectException, IOException {
        boolean bl;
        WorkingTreeIterator wtIt;
        DirCacheIterator dcIt;
        NameConflictTreeWalk tw = new NameConflictTreeWalk(this.repo);
        try {
            tw.addTree(new DirCacheIterator(this.dc));
            tw.addTree(new FileTreeIterator(this.repo));
            tw.setRecursive(true);
            tw.setFilter(PathFilter.create(path2));
            while (tw.next()) {
                dcIt = tw.getTree(0, DirCacheIterator.class);
                wtIt = tw.getTree(1, WorkingTreeIterator.class);
                if (dcIt != null && wtIt != null) break block5;
                bl = true;
                Object var7_8 = null;
            }
        }
        catch (Throwable throwable2) {
            Object var7_11 = null;
            tw.release();
            throw throwable2;
        }
        {
            block5: {
                tw.release();
                return bl;
            }
            if (!wtIt.isModified(dcIt.getDirCacheEntry(), true, this.walk.getObjectReader())) continue;
            boolean bl2 = true;
            Object var7_9 = null;
            tw.release();
            return bl2;
        }
        boolean bl3 = false;
        Object var7_10 = null;
        tw.release();
        return bl3;
    }

    private boolean isModified_IndexTree(String path2, ObjectId iId, FileMode iMode, ObjectId tId, FileMode tMode, ObjectId rootTree) throws CorruptObjectException, IOException {
        if (iMode != tMode) {
            return true;
        }
        if (FileMode.TREE.equals(iMode) && (iId == null || ObjectId.zeroId().equals(iId))) {
            return this.isModifiedSubtree_IndexTree(path2, rootTree);
        }
        return !this.equalIdAndMode(iId, iMode, tId, tMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isModifiedSubtree_IndexTree(String path2, ObjectId tree2) throws CorruptObjectException, IOException {
        boolean bl;
        NameConflictTreeWalk tw;
        block8: {
            boolean bl2;
            block7: {
                boolean bl3;
                block6: {
                    boolean bl4;
                    block5: {
                        tw = new NameConflictTreeWalk(this.repo);
                        try {
                            tw.addTree(new DirCacheIterator(this.dc));
                            tw.addTree(tree2);
                            tw.setRecursive(true);
                            tw.setFilter(PathFilter.create(path2));
                            while (tw.next()) {
                                DirCacheIterator dcIt = tw.getTree(0, DirCacheIterator.class);
                                AbstractTreeIterator treeIt = tw.getTree(1, AbstractTreeIterator.class);
                                if (dcIt == null || treeIt == null) {
                                    bl4 = true;
                                    Object var8_10 = null;
                                    break block5;
                                }
                                if (dcIt.getEntryRawMode() != treeIt.getEntryRawMode()) {
                                    bl3 = true;
                                    break block6;
                                }
                                if (dcIt.getEntryObjectId().equals(treeIt.getEntryObjectId())) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl = false;
                            break block8;
                        }
                        catch (Throwable throwable2) {
                            Object var8_14 = null;
                            tw.release();
                            throw throwable2;
                        }
                    }
                    tw.release();
                    return bl4;
                }
                Object var8_11 = null;
                tw.release();
                return bl3;
            }
            Object var8_12 = null;
            tw.release();
            return bl2;
        }
        Object var8_13 = null;
        tw.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void checkoutEntry(Repository repository, File f2, DirCacheEntry entry2) throws IOException {
        ObjectReader or = repository.newObjectReader();
        try {
            DirCacheCheckout.checkoutEntry(repository, f2, entry2, or);
            Object var5_4 = null;
            or.release();
        }
        catch (Throwable throwable2) {
            Object var5_5 = null;
            or.release();
            throw throwable2;
        }
    }

    @Deprecated
    public static void checkoutEntry(Repository repo, File f2, DirCacheEntry entry2, ObjectReader or) throws IOException {
        if (f2 == null || repo.getWorkTree() == null) {
            throw new IllegalArgumentException();
        }
        if (!f2.equals(new File(repo.getWorkTree(), entry2.getPathString()))) {
            throw new IllegalArgumentException();
        }
        DirCacheCheckout.checkoutEntry(repo, entry2, or);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkoutEntry(Repository repo, DirCacheEntry entry2, ObjectReader or) throws IOException {
        ObjectLoader ol = or.open(entry2.getObjectId());
        File f2 = new File(repo.getWorkTree(), entry2.getPathString());
        File parentDir = f2.getParentFile();
        FileUtils.mkdirs(parentDir, true);
        FS fs = repo.getFS();
        WorkingTreeOptions opt2 = repo.getConfig().get(WorkingTreeOptions.KEY);
        if (entry2.getFileMode() == FileMode.SYMLINK && opt2.getSymLinks() == CoreConfig.SymLinks.TRUE) {
            byte[] bytes2 = ol.getBytes();
            String target = RawParseUtils.decode(bytes2);
            fs.createSymLink(f2, target);
            entry2.setLength(bytes2.length);
            entry2.setLastModified(fs.lastModified(f2));
            return;
        }
        File tmpFile = File.createTempFile("._" + f2.getName(), null, parentDir);
        OutputStream channel = new FileOutputStream(tmpFile);
        if (opt2.getAutoCRLF() == CoreConfig.AutoCRLF.TRUE) {
            channel = new AutoCRLFOutputStream(channel);
        }
        try {
            ol.copyTo(channel);
            Object var11_12 = null;
        }
        catch (Throwable throwable2) {
            Object var11_13 = null;
            channel.close();
            throw throwable2;
        }
        channel.close();
        entry2.setLength(opt2.getAutoCRLF() == CoreConfig.AutoCRLF.TRUE ? tmpFile.length() : (long)((int)ol.getSize()));
        if (opt2.isFileMode() && fs.supportsExecute()) {
            if (FileMode.EXECUTABLE_FILE.equals(entry2.getRawMode())) {
                if (!fs.canExecute(tmpFile)) {
                    fs.setExecute(tmpFile, true);
                }
            } else if (fs.canExecute(tmpFile)) {
                fs.setExecute(tmpFile, false);
            }
        }
        try {
            FileUtils.rename(tmpFile, f2);
        }
        catch (IOException e) {
            throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, tmpFile.getPath(), f2.getPath()));
        }
        entry2.setLastModified(f2.lastModified());
    }

    private static void checkValidPath(CanonicalTreeParser t) throws InvalidPathException {
        ObjectChecker chk = new ObjectChecker().setSafeForWindows(SystemReader.getInstance().isWindows()).setSafeForMacOS(SystemReader.getInstance().isMacOS());
        for (CanonicalTreeParser i = t; i != null; i = i.getParent()) {
            DirCacheCheckout.checkValidPathSegment(chk, i);
        }
    }

    @Deprecated
    public static void checkValidPath(String path2) throws InvalidPathException {
        try {
            SystemReader.getInstance().checkPath(path2);
        }
        catch (CorruptObjectException e) {
            InvalidPathException p = new InvalidPathException(path2);
            p.initCause(e);
            throw p;
        }
    }

    private static void checkValidPathSegment(ObjectChecker chk, CanonicalTreeParser t) throws InvalidPathException {
        try {
            int ptr = t.getNameOffset();
            int end2 = ptr + t.getNameLength();
            chk.checkPathSegment(t.getEntryPathBuffer(), ptr, end2);
        }
        catch (CorruptObjectException err2) {
            String path2 = t.getEntryPathString();
            InvalidPathException i = new InvalidPathException(path2);
            i.initCause(err2);
            throw i;
        }
    }
}

