/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import org.eclipse.jgit.ignore.internal.AbstractMatcher;
import org.eclipse.jgit.ignore.internal.Strings;

public class NameMatcher
extends AbstractMatcher {
    final boolean beginning;
    final char slash;
    final String subPattern;

    NameMatcher(String pattern2, Character pathSeparator, boolean dirOnly) {
        super(pattern2, dirOnly);
        this.slash = Strings.getPathSeparator(pathSeparator);
        this.beginning = pattern2.length() == 0 ? false : pattern2.charAt(0) == this.slash;
        this.subPattern = !this.beginning ? pattern2 : pattern2.substring(1);
    }

    public boolean matches(String path2, boolean assumeDirectory) {
        int end2 = 0;
        int firstChar = 0;
        do {
            boolean match;
            if (!(match = this.matches(path2, firstChar = this.getFirstNotSlash(path2, end2), end2 = this.getFirstSlash(path2, firstChar), assumeDirectory))) continue;
            return !this.dirOnly ? true : end2 > 0 && end2 != path2.length() || assumeDirectory;
        } while (!this.beginning && end2 != path2.length());
        return false;
    }

    public boolean matches(String segment, int startIncl, int endExcl, boolean assumeDirectory) {
        String s2 = this.subPattern;
        if (s2.length() != endExcl - startIncl) {
            return false;
        }
        for (int i = 0; i < s2.length(); ++i) {
            char c2;
            char c1 = s2.charAt(i);
            if (c1 == (c2 = segment.charAt(i + startIncl))) continue;
            return false;
        }
        return true;
    }

    private int getFirstNotSlash(String s2, int start) {
        int slashIdx = s2.indexOf(this.slash, start);
        return slashIdx == start ? start + 1 : start;
    }

    private int getFirstSlash(String s2, int start) {
        int slashIdx = s2.indexOf(this.slash, start);
        return slashIdx == -1 ? s2.length() : slashIdx;
    }
}

