/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.WriteConfig;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

public class ReflogWriter {
    private final Repository parent;
    private final File logsDir;
    private final File logsRefsDir;
    private final boolean forceWrite;

    public static String refLockFor(String name2) {
        return name2 + ".lock";
    }

    public ReflogWriter(Repository repository) {
        this(repository, false);
    }

    public ReflogWriter(Repository repository, boolean forceWrite) {
        FS fs = repository.getFS();
        this.parent = repository;
        File gitDir = repository.getDirectory();
        this.logsDir = fs.resolve(gitDir, "logs");
        this.logsRefsDir = fs.resolve(gitDir, "logs/refs/");
        this.forceWrite = forceWrite;
    }

    public Repository getRepository() {
        return this.parent;
    }

    public ReflogWriter create() throws IOException {
        FileUtils.mkdir(this.logsDir);
        FileUtils.mkdir(this.logsRefsDir);
        FileUtils.mkdir(new File(this.logsRefsDir, "refs/heads/".substring("refs/".length())));
        return this;
    }

    public File logFor(String name2) {
        if (name2.startsWith("refs/")) {
            name2 = name2.substring("refs/".length());
            return new File(this.logsRefsDir, name2);
        }
        return new File(this.logsDir, name2);
    }

    public ReflogWriter log(String refName, ReflogEntry entry2) throws IOException {
        return this.log(refName, entry2.getOldId(), entry2.getNewId(), entry2.getWho(), entry2.getComment());
    }

    public ReflogWriter log(String refName, ObjectId oldId, ObjectId newId, PersonIdent ident2, String message) throws IOException {
        byte[] encoded = this.encode(oldId, newId, ident2, message);
        return this.log(refName, encoded);
    }

    public ReflogWriter log(RefUpdate update2, String msg, boolean deref) throws IOException {
        ObjectId oldId = update2.getOldObjectId();
        ObjectId newId = update2.getNewObjectId();
        Ref ref2 = update2.getRef();
        PersonIdent ident2 = update2.getRefLogIdent();
        ident2 = ident2 == null ? new PersonIdent(this.parent) : new PersonIdent(ident2);
        byte[] rec = this.encode(oldId, newId, ident2, msg);
        if (deref && ref2.isSymbolic()) {
            this.log(ref2.getName(), rec);
            this.log(ref2.getLeaf().getName(), rec);
        } else {
            this.log(ref2.getName(), rec);
        }
        return this;
    }

    private byte[] encode(ObjectId oldId, ObjectId newId, PersonIdent ident2, String message) {
        StringBuilder r = new StringBuilder();
        r.append(ObjectId.toString(oldId));
        r.append(' ');
        r.append(ObjectId.toString(newId));
        r.append(' ');
        r.append(ident2.toExternalString());
        r.append('\t');
        r.append(message.replace("\r\n", " ").replace("\n", " "));
        r.append('\n');
        return Constants.encode(r.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReflogWriter log(String refName, byte[] rec) throws IOException {
        FileOutputStream out;
        boolean write2;
        File log2 = this.logFor(refName);
        boolean bl = write2 = this.forceWrite || this.isLogAllRefUpdates() && this.shouldAutoCreateLog(refName) || log2.isFile();
        if (!write2) {
            return this;
        }
        WriteConfig wc = this.getRepository().getConfig().get(WriteConfig.KEY);
        try {
            out = new FileOutputStream(log2, true);
        }
        catch (FileNotFoundException err2) {
            File dir = log2.getParentFile();
            if (dir.exists()) {
                throw err2;
            }
            if (!dir.mkdirs() && !dir.isDirectory()) {
                throw new IOException(MessageFormat.format(JGitText.get().cannotCreateDirectory, dir));
            }
            out = new FileOutputStream(log2, true);
        }
        try {
            if (wc.getFSyncRefFiles()) {
                FileChannel fc = out.getChannel();
                ByteBuffer buf = ByteBuffer.wrap(rec);
                while (0 < buf.remaining()) {
                    fc.write(buf);
                }
                fc.force(true);
            } else {
                out.write(rec);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable2) {
            Object var10_11 = null;
            out.close();
            throw throwable2;
        }
        out.close();
        return this;
    }

    private boolean isLogAllRefUpdates() {
        return this.parent.getConfig().get(CoreConfig.KEY).isLogAllRefUpdates();
    }

    private boolean shouldAutoCreateLog(String refName) {
        return refName.equals("HEAD") || refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/") || refName.equals("refs/stash");
    }
}

