/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

class UnpackedObjectCache {
    private static final int INITIAL_BITS = 5;
    private static final int MAX_BITS = 11;
    private volatile Table table = new Table(5);

    UnpackedObjectCache() {
    }

    boolean isUnpacked(AnyObjectId objectId) {
        return this.table.contains(objectId);
    }

    void add(AnyObjectId objectId) {
        Table t = this.table;
        if (!t.add(objectId)) {
            Table n = new Table(Math.min(t.bits + 1, 11));
            n.add(objectId);
            this.table = n;
        }
    }

    void remove(AnyObjectId objectId) {
        if (this.isUnpacked(objectId)) {
            this.clear();
        }
    }

    void clear() {
        this.table = new Table(5);
    }

    private static class Table {
        private static final int MAX_CHAIN = 8;
        private final AtomicReferenceArray<ObjectId> ids;
        private final int shift;
        final int bits;

        Table(int bits2) {
            this.ids = new AtomicReferenceArray(1 << bits2);
            this.shift = 32 - bits2;
            this.bits = bits2;
        }

        boolean contains(AnyObjectId toFind) {
            ObjectId obj2;
            int i = this.index(toFind);
            for (int n = 0; n < 8 && (obj2 = this.ids.get(i)) != null; ++n) {
                if (AnyObjectId.equals(obj2, toFind)) {
                    return true;
                }
                if (++i != this.ids.length()) continue;
                i = 0;
            }
            return false;
        }

        boolean add(AnyObjectId toAdd) {
            int i = this.index(toAdd);
            int n = 0;
            while (n < 8) {
                ObjectId obj2 = this.ids.get(i);
                if (obj2 == null) {
                    if (!this.ids.compareAndSet(i, null, toAdd.copy())) continue;
                    return true;
                }
                if (AnyObjectId.equals(obj2, toAdd)) {
                    return true;
                }
                if (++i == this.ids.length()) {
                    i = 0;
                }
                ++n;
            }
            return false;
        }

        private int index(AnyObjectId id) {
            return id.hashCode() >>> this.shift;
        }
    }
}

