/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.util.SystemReader;

public class PersonIdent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String emailAddress;
    private final long when;
    private final int tzOffset;

    public PersonIdent(Repository repo) {
        this(repo.getConfig().get(UserConfig.KEY));
    }

    public PersonIdent(PersonIdent pi) {
        this(pi.getName(), pi.getEmailAddress());
    }

    public PersonIdent(String aName, String aEmailAddress) {
        this(aName, aEmailAddress, SystemReader.getInstance().getCurrentTime());
    }

    public PersonIdent(PersonIdent pi, Date when, TimeZone tz) {
        this(pi.getName(), pi.getEmailAddress(), when, tz);
    }

    public PersonIdent(PersonIdent pi, Date aWhen) {
        this(pi.getName(), pi.getEmailAddress(), aWhen.getTime(), pi.tzOffset);
    }

    public PersonIdent(String aName, String aEmailAddress, Date aWhen, TimeZone aTZ) {
        this(aName, aEmailAddress, aWhen.getTime(), aTZ.getOffset(aWhen.getTime()) / 60000);
    }

    public PersonIdent(PersonIdent pi, long aWhen, int aTZ) {
        this(pi.getName(), pi.getEmailAddress(), aWhen, aTZ);
    }

    private PersonIdent(String aName, String aEmailAddress, long when) {
        this(aName, aEmailAddress, when, SystemReader.getInstance().getTimezone(when));
    }

    private PersonIdent(UserConfig config) {
        this(config.getCommitterName(), config.getCommitterEmail());
    }

    public PersonIdent(String aName, String aEmailAddress, long aWhen, int aTZ) {
        if (aName == null) {
            throw new IllegalArgumentException("Name of PersonIdent must not be null.");
        }
        if (aEmailAddress == null) {
            throw new IllegalArgumentException("E-mail address of PersonIdent must not be null.");
        }
        this.name = aName;
        this.emailAddress = aEmailAddress;
        this.when = aWhen;
        this.tzOffset = aTZ;
    }

    public String getName() {
        return this.name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Date getWhen() {
        return new Date(this.when);
    }

    public TimeZone getTimeZone() {
        StringBuilder tzId = new StringBuilder(8);
        tzId.append("GMT");
        this.appendTimezone(tzId);
        return TimeZone.getTimeZone(tzId.toString());
    }

    public int getTimeZoneOffset() {
        return this.tzOffset;
    }

    public int hashCode() {
        int hc = this.getEmailAddress().hashCode();
        hc *= 31;
        return hc += (int)(this.when / 1000L);
    }

    public boolean equals(Object o) {
        if (o instanceof PersonIdent) {
            PersonIdent p = (PersonIdent)o;
            return this.getName().equals(p.getName()) && this.getEmailAddress().equals(p.getEmailAddress()) && this.when / 1000L == p.when / 1000L;
        }
        return false;
    }

    public String toExternalString() {
        StringBuilder r = new StringBuilder();
        r.append(this.getName().trim());
        r.append(" <");
        r.append(this.getEmailAddress().trim());
        r.append("> ");
        r.append(this.when / 1000L);
        r.append(' ');
        this.appendTimezone(r);
        return r.toString();
    }

    private void appendTimezone(StringBuilder r) {
        char sign2;
        int offset = this.tzOffset;
        if (offset < 0) {
            sign2 = '-';
            offset = -offset;
        } else {
            sign2 = '+';
        }
        int offsetHours = offset / 60;
        int offsetMins = offset % 60;
        r.append(sign2);
        if (offsetHours < 10) {
            r.append('0');
        }
        r.append(offsetHours);
        if (offsetMins < 10) {
            r.append('0');
        }
        r.append(offsetMins);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        SimpleDateFormat dtfmt = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy Z", Locale.US);
        dtfmt.setTimeZone(this.getTimeZone());
        r.append("PersonIdent[");
        r.append(this.getName());
        r.append(", ");
        r.append(this.getEmailAddress());
        r.append(", ");
        r.append(dtfmt.format(this.when));
        r.append("]");
        return r.toString();
    }
}

