
For the latest and greatest articles on fabric8 check out the [fabric8 blog](https://blog.fabric8.io) and the [fabric8 video stream](https://vimeo.com/tag:fabric8)

### Videos

* [Developing Java based microservices ready for the world of containers](https://www.youtube.com/watch?v=Xlw88tFeVf0&index=5&list=PLUDjw7NbNcoyOyhrIIw9cChAHWdaCxIob) video by Claus Ibsen from JDKIO in September 2016 talking about how Java Developers can build microservices using Java/Spring-Boot/WildFly-Swarm and run on Kubernetes with help from fabric8 tooling.
* [Automation of CD for Microservices](https://medium.com/fabric8-io/automation-for-Microservices-5a8ed0ea100d#.ttymo1yv4) video by James Rawlings shows starting from zero right through to running everything that is required to build, test and release a new project. It shows how we can use automation without compromising on control.
* [Fabric8 Camel Microservices for Docker and Kubernetes](https://www.youtube.com/watch?v=ouJ3SQHnQ6I) video from RigaDevDay 2016 by Claus Ibsen, presenting how Java developers can get started with kubernetes/fabric8 and develop microservices using Java and Camel.
* [fabric8 - Java developer tools for Kubernetes and OpenShift](https://medium.com/fabric8-io/fabric8-java-developer-tools-for-kubernetes-and-openshift-by-roland-hu%C3%9F-devoxx-video-f0aa651d804#.i7pu9lnbg) video from Devoxx 2015 by Roland Huss, who gives a great overview of how fabric8, Kubernetes and OpenShift are all related.
* [Getting started with fabric8](https://medium.com/fabric8-io/getting-started-with-fabric8-7bd7ff14958e) by [James Rawlings](https://medium.com/@jdrawlings) zero to running with fabric8 on OpenShift V3 with Vagrant
* [Create and explore Continuous Delivery Pipelines with Fabric8 and Jenkins on OpenShift](https://medium.com/fabric8-io/create-and-explore-continuous-delivery-pipelines-with-fabric8-and-jenkins-on-openshift-661aa82cb45a) by James Strachan
* [Video recording of walk-through of the simple Java fat-jar fabric8 quickstart](https://medium.com/fabric8-io/cheers-video-recording-of-walk-through-of-the-simple-java-fat-jar-fabric8-quickstart-f4af9e58af76) by Claus Ibsen
* [One Stop multi stage CI / CD with fabric8 and Chat](https://medium.com/fabric8-io/continuous-delivery-with-fabric8-d3c7cad76954) by [James Rawlings](https://medium.com/@jdrawlings)
* [Using the Fabric8 Console on GKE](https://vimeo.com/134408470) by [James Rawlings](https://medium.com/@jdrawlings)
* [demo using the Fabric8 console to work with Kubernetes and OpenShift V3 apps](https://medium.com/@jstrachan/demo-using-the-fabric8-console-to-work-with-kubernetes-and-openshift-v3-apps-42feb965c479) a presentation by [James Strachan](http://twitter.com/jstrachan) at the [Kubernetes meetup London](http://www.meetup.com/Kubernetes-London/events/221521966/)
* [demo using fabric8 to create a new Java project, git repo and automatically build & deploy it on OpenShift V3 &amp; Kubernetes using Docker](https://medium.com/@jstrachan/demo-using-fabric8-to-create-a-new-java-project-git-repo-and-automatically-build-deploy-it-on-d34d776098a9)
* [Easy micro services with fabric8, docker and kubernetes!](https://skillsmatter.com/skillscasts/5476-easy-Microservices-on-premise-on-docker-or-in-the-clouds-with-fabric8) or you can [view the slides](http://fabric8.io/presentations/fabric8-mucon/index.html) a presentation by [James Strachan](http://twitter.com/jstrachan) at [muCon](https://skillsmatter.com/conferences/6312-mucon)
* [fabric8 video album](https://vimeo.com/album/3351330/sort:date/format:thumbnail) has various demos of fabric8
* [fabric8 video stream](https://vimeo.com/tag:fabric8) has various other demos of fabric8
* [JBoss Fuse demo video album](https://vimeo.com/album/2635012) has various demos of fabric8 v1

### Articles and presentations on fabric8

* [Kubernetes for Java developers](http://fabric8.io/presentations/kubernetes-for-java-developers/) slides by [James Strachan](http://twitter.com/jstrachan) from Red Hat's [MSA day in London](http://www.redhatonline.com/uk/seminar/Microservices-architecture-developer-day/)
* [Kubernetes for developers](https://medium.com/fabric8-io/kubernetes-for-developers-2a9c7202fcd3) by [James Strachan](http://twitter.com/jstrachan)
* [Google systems guru explains why containers are the future of computing](https://medium.com/s-c-a-l-e/google-systems-guru-explains-why-containers-are-the-future-of-computing-87922af2cf95)
* [4-day Docker and Kubernetes Training](http://blog.christianposta.com/kubernetes/3-day-docker-and-kubernetes-training/) by Christian Posta blog and plenty of slides from a deep dive Kubernetes, OpenShift and Fabric8 training.
* [Developing services on Kubernetes using OpenShift and Fabric8](http://fabric8.io/presentations/kubernetes-london-openshift-fabric8/#/) by [James Strachan](http://twitter.com/jstrachan) at the [Kubernetes Meetup in London](http://www.meetup.com/Kubernetes-London/events/221521966/)
* [Fabric8 Version 2 released](http://rajdavies.blogspot.co.uk/2014/11/fabric8-version-20-released-next.html) by [Rob Davies](http://rajdavies.blogspot.co.uk/)
* [Fabric8 V2, Docker, Kubernetes & OpenShift V3 and Jube! Oh My!](https://medium.com/@jstrachan/fabric8-v2-docker-kubernetes-openshift-v3-and-jube-oh-my-4aadddf2037) by [James Strachan](http://twitter.com/jstrachan)
* [An Introduction to Fabric8 and Why It's So Important for Integration](http://java.dzone.com/articles/introduction-fabric8-and-why) by [Steven Fisher](http://java.dzone.com/users/stevef1uk99)
* [Meet Fabric8: An open-source integration platform based on Camel and ActiveMQ](http://www.christianposta.com/blog/?p=376) by [Christian Posta](http://www.christianposta.com/blog/)
* [Fabric8 Introduction](http://fabric8.io/presentations/devnation-2014-intro/index.html#/) at [DevNation](http://devnation.org) 2014 by [Ioannis Canellos](http://twitter.com/iocanel) and [James Strachan](http://twitter.com/jstrachan)
* [Fabric8 Deep Dive](http://fabric8.io/presentations/devnation-2014-deepdive/index.html#/) at [DevNation](http://devnation.org) 2014 by [Ioannis Canellos](http://twitter.com/iocanel) and [James Strachan](http://twitter.com/jstrachan)
* [Micro Services the easy way with Fabric8](http://macstrac.blogspot.co.uk/2014/05/micro-services-with-fabric8.html) by [James Strachan](http://twitter.com/jstrachan)
* [Simplify your integrations with Apache Camel and Fabric8](http://java.dzone.com/articles/video-simplify-your) by [Christian Posta](http://www.christianposta.com/blog/)
* [Continuous Integration with JBoss Fuse, Jenkins and Nexus](http://giallone.blogspot.se/2014/05/continuous-integration-with-jboss-fuse.html) by [Paolo Antinori](http://giallone.blogspot.se/)
* [DevOps with Apache Tomcat/TomEE and Fabric8](http://www.christianposta.com/blog/?p=393) by [Christian Posta](http://www.christianposta.com/blog/)
* [Apache Camel in the Clouds](http://fabric8.io/presentations/camel-in-the-clouds-2014/index.html) a presentation by [James Strachan](http://twitter.com/jstrachan)
* [fabric8 ... and Docker, Kubernetes & OpenShift](http://de.slideshare.net/roland.huss/fabric8-and-docker-kubernetes-openshift) presentation by [Roland Huss](https://ro14nd.de) at [DevOpsCon 2015](http://devopsconference.de/2015/de), Berlin

### Docker, Kubernetes and OpenShift

* [The New PaaS](http://reinvent-hripps.rhcloud.com/#/): Using Docker and Containers to Simplify Your Life and Accelerate Development on AWS by [N. Harrison Ripps](http://twitter.com/nhripps) and [Steven Pousty](http://twitter.com/TheSteve0)
* [An Introduction to Kubernetes](https://www.digitalocean.com/community/tutorials/an-introduction-to-kubernetes) by [Digital Ocean](https://www.digitalocean.com)
