/**
 *  Copyright 2005-2017 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package org.jboss.fuse.quickstarts.beginner.camel.eip;

/**
 *  Copyright 2005-2014 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */

import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * Just a simple JUnit test class for {@link RegionSupport}
 */
public class RegionSupportTest {

    private final RegionSupport support = new RegionSupport();

    @Test
    public void testGetRegion() {
        assertEquals(RegionSupport.APAC, support.getRegion("AU"));
        assertEquals(RegionSupport.EMEA, support.getRegion("BE"));
        assertEquals(RegionSupport.EMEA, support.getRegion("UK"));
        assertEquals(RegionSupport.AMER, support.getRegion("US"));
    }

}
