#!/bin/bash

while getopts ":b:p:" opt; do
  case "${opt}" in
    b) BRANCH=${OPTARG}
      ;;
    p) PRODUCT_VERSION=${OPTARG}
      ;;
    :)
      echo "ERROR: Option -$OPTARG requires an argument"
      exit 1
      ;;
    \?)
      echo "ERROR: Invalid option -$OPTARG"
      exit 1
      ;;
  esac
done
shift $((OPTIND-1))

#######################################
#
# Sync the metadata bundle repository
#
#######################################

SRC_ROOT="../.."

if [ ! -f "$(basename ${0})" ]; then
  echo "Please execute this script from its own directory"
  exit 1
fi

if [ -z "${BRANCH}" ] || [ -z "${PRODUCT_VERSION}" ]; then
  echo "Error: ${0} -b <branch> -p <product-version>"
  exit 1
fi

pushd "${SRC_ROOT}/install/operator/config" > /dev/null

make clean bundle
if [ $? != 0 ]; then
  echo "Error: Failed to create bundle successfully"
  exit 1
fi

BUNDLE_DIR=$(mktemp -d -t fuse-prod-metadata-XXXXXX)
pushd ${BUNDLE_DIR} > /dev/null

git clone git@github.com:jboss-fuse/fuse-online-operator-prod-operator-metadata.git .
if [ $? != 0 ]; then
  echo "Error: Failed to checkout repository successfully"
  exit 1
fi

#
# Checkout current branch
# Branch to a new version branch
#
git checkout -b "fuse-${PRODUCT_VERSION}-openshift-rhel-8" "origin/${BRANCH}"
if [ $? != 0 ]; then
  echo "Error: Failed to branch and checkout successfully"
  exit 1
fi

popd > /dev/null

echo -n "Using rsync to synchronize the bundle output ..."
rsync -r bundle/* ${BUNDLE_DIR}/
echo "Done"

pushd ${BUNDLE_DIR} > /dev/null
git add .
git commit -m "Sync with jboss-fuse/syndesis bundle generation"
popd > /dev/null

#
# Manually check before pushing
#
echo "Please review the latest commit at ${BUNDLE_DIR} before pushing it."
popd > /dev/null
