/*
 * ModeShape (http://www.modeshape.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.modeshape.jcr.index.lucene.query;

import java.util.function.Function;
import java.util.regex.Pattern;

/**
 * Lucene query which uses Java Regex syntax and flags to match the content stored in the indexes against a {@link Pattern}
 * 
 * @author Horia Chiorean (hchiorea@redhat.com)
 */
public final class RegexQuery extends CompareQuery<String> {
    
    public RegexQuery(String fieldName,
                      Pattern pattern,
                      Function<String, String> caseOperation) {
        super(fieldName, pattern.pattern(), (storedValue, regexp) -> pattern.matcher(storedValue).matches(), caseOperation);
    }
    
    @Override
    protected String convertValue(String casedValue) {
        return casedValue;
    }
}
