/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.params.HttpParams;

public class LaxContentLengthStrategy
implements ContentLengthStrategy {
    public long determineLength(HttpMessage message) throws HttpException {
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        HttpParams params2 = message.getParams();
        boolean strict2 = params2.isParameterTrue("http.protocol.strict-transfer-encoding");
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (transferEncodingHeader != null) {
            HeaderElement[] encodings2 = null;
            try {
                encodings2 = transferEncodingHeader.getElements();
            }
            catch (ParseException px) {
                throw new ProtocolException("Invalid Transfer-Encoding header value: " + transferEncodingHeader, px);
            }
            if (strict2) {
                for (int i = 0; i < encodings2.length; ++i) {
                    String encoding = encodings2[i].getName();
                    if (encoding == null || encoding.length() <= 0 || encoding.equalsIgnoreCase("chunked") || encoding.equalsIgnoreCase("identity")) continue;
                    throw new ProtocolException("Unsupported transfer encoding: " + encoding);
                }
            }
            int len = encodings2.length;
            if ("identity".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                return -1L;
            }
            if (len > 0 && "chunked".equalsIgnoreCase(encodings2[len - 1].getName())) {
                return -2L;
            }
            if (strict2) {
                throw new ProtocolException("Chunk-encoding must be the last one applied");
            }
            return -1L;
        }
        if (contentLengthHeader != null) {
            long contentlen = -1L;
            Header[] headers = message.getHeaders("Content-Length");
            if (strict2 && headers.length > 1) {
                throw new ProtocolException("Multiple content length headers");
            }
            for (int i = headers.length - 1; i >= 0; --i) {
                Header header = headers[i];
                try {
                    contentlen = Long.parseLong(header.getValue());
                    break;
                }
                catch (NumberFormatException e) {
                    if (!strict2) continue;
                    throw new ProtocolException("Invalid content length: " + header.getValue());
                }
            }
            if (contentlen >= 0L) {
                return contentlen;
            }
            return -1L;
        }
        return -1L;
    }
}

