/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawParseUtils;

public class FormatError {
    private final byte[] buf;
    private final int offset;
    private final Severity severity;
    private final String message;

    FormatError(byte[] buffer2, int ptr, Severity sev, String msg) {
        this.buf = buffer2;
        this.offset = ptr;
        this.severity = sev;
        this.message = msg;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getLineText() {
        int eol = RawParseUtils.nextLF(this.buf, this.offset);
        return RawParseUtils.decode(Constants.CHARSET, this.buf, this.offset, eol);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append(this.getSeverity().name().toLowerCase());
        r.append(": at offset ");
        r.append(this.getOffset());
        r.append(": ");
        r.append(this.getMessage());
        r.append("\n");
        r.append("  in ");
        r.append(this.getLineText());
        return r.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        WARNING,
        ERROR;

    }
}

