/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;

public class RevTag
extends RevObject {
    private RevObject object;
    private byte[] buffer;
    private String tagName;

    public static RevTag parse(byte[] raw2) throws CorruptObjectException {
        return RevTag.parse(new RevWalk((ObjectReader)null), raw2);
    }

    public static RevTag parse(RevWalk rw, byte[] raw2) throws CorruptObjectException {
        ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();
        boolean retain2 = rw.isRetainBody();
        rw.setRetainBody(true);
        RevTag r = rw.lookupTag(fmt.idFor(4, raw2));
        r.parseCanonical(rw, raw2);
        rw.setRetainBody(retain2);
        return r;
    }

    protected RevTag(AnyObjectId id2) {
        super(id2);
    }

    void parseHeaders(RevWalk walk2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.parseCanonical(walk2, walk2.getCachedBytes(this));
    }

    void parseBody(RevWalk walk2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.buffer == null) {
            this.buffer = walk2.getCachedBytes(this);
            if ((this.flags & 1) == 0) {
                this.parseCanonical(walk2, this.buffer);
            }
        }
    }

    void parseCanonical(RevWalk walk2, byte[] rawTag) throws CorruptObjectException {
        MutableInteger pos = new MutableInteger();
        pos.value = 53;
        int oType = Constants.decodeTypeString(this, rawTag, (byte)10, pos);
        walk2.idBuffer.fromString(rawTag, 7);
        this.object = walk2.lookupAny(walk2.idBuffer, oType);
        int p = pos.value += 4;
        int nameEnd = RawParseUtils.nextLF(rawTag, p) - 1;
        this.tagName = RawParseUtils.decode(Constants.CHARSET, rawTag, p, nameEnd);
        if (walk2.isRetainBody()) {
            this.buffer = rawTag;
        }
        this.flags |= 1;
    }

    public final int getType() {
        return 4;
    }

    public final PersonIdent getTaggerIdent() {
        byte[] raw2 = this.buffer;
        int nameB = RawParseUtils.tagger(raw2, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw2, nameB);
    }

    public final String getFullMessage() {
        byte[] raw2 = this.buffer;
        int msgB = RawParseUtils.tagMessage(raw2, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw2);
        return RawParseUtils.decode(enc, raw2, msgB, raw2.length);
    }

    public final String getShortMessage() {
        byte[] raw2 = this.buffer;
        int msgB = RawParseUtils.tagMessage(raw2, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw2);
        int msgE = RawParseUtils.endOfParagraph(raw2, msgB);
        String str = RawParseUtils.decode(enc, raw2, msgB, msgE);
        if (RevCommit.hasLF(raw2, msgB, msgE)) {
            str = StringUtils.replaceLineBreaksWithSpace(str);
        }
        return str;
    }

    public final RevObject getObject() {
        return this.object;
    }

    public final String getTagName() {
        return this.tagName;
    }

    final void disposeBody() {
        this.buffer = null;
    }
}

