/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.RelativeDateFormatter;
import org.eclipse.jgit.util.SystemReader;

public class GitDateFormatter {
    private DateFormat dateTimeInstance;
    private DateFormat dateTimeInstance2;
    private final Format format;

    public GitDateFormatter(Format format2) {
        this.format = format2;
        switch (format2) {
            default: {
                break;
            }
            case DEFAULT: {
                this.dateTimeInstance = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy Z", Locale.US);
                break;
            }
            case ISO: {
                this.dateTimeInstance = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US);
                break;
            }
            case LOCAL: {
                this.dateTimeInstance = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
                break;
            }
            case RFC: {
                this.dateTimeInstance = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
                break;
            }
            case SHORT: {
                this.dateTimeInstance = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                break;
            }
            case LOCALE: 
            case LOCALELOCAL: {
                SystemReader systemReader = SystemReader.getInstance();
                this.dateTimeInstance = systemReader.getDateTimeInstance(2, 2);
                this.dateTimeInstance2 = systemReader.getSimpleDateFormat("Z");
            }
        }
    }

    public String formatDate(PersonIdent ident2) {
        switch (this.format) {
            case RAW: {
                int offset = ident2.getTimeZoneOffset();
                String sign2 = offset < 0 ? "-" : "+";
                int offset2 = offset < 0 ? -offset : offset;
                int hours = offset2 / 60;
                int minutes = offset2 % 60;
                return String.format("%d %s%02d%02d", ident2.getWhen().getTime() / 1000L, sign2, hours, minutes);
            }
            case RELATIVE: {
                return RelativeDateFormatter.format(ident2.getWhen());
            }
            case LOCAL: 
            case LOCALELOCAL: {
                this.dateTimeInstance.setTimeZone(SystemReader.getInstance().getTimeZone());
                return this.dateTimeInstance.format(ident2.getWhen());
            }
            case LOCALE: {
                TimeZone tz = ident2.getTimeZone();
                if (tz == null) {
                    tz = SystemReader.getInstance().getTimeZone();
                }
                this.dateTimeInstance.setTimeZone(tz);
                this.dateTimeInstance2.setTimeZone(tz);
                return this.dateTimeInstance.format(ident2.getWhen()) + " " + this.dateTimeInstance2.format(ident2.getWhen());
            }
        }
        TimeZone tz = ident2.getTimeZone();
        if (tz == null) {
            tz = SystemReader.getInstance().getTimeZone();
        }
        this.dateTimeInstance.setTimeZone(ident2.getTimeZone());
        return this.dateTimeInstance.format(ident2.getWhen());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        DEFAULT,
        RELATIVE,
        LOCAL,
        ISO,
        RFC,
        SHORT,
        RAW,
        LOCALE,
        LOCALELOCAL;

    }
}

