/**
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.atlasmap.csv.v2;

import com.fasterxml.jackson.annotation.JsonTypeInfo;

import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;

@JsonTypeInfo(include = JsonTypeInfo.As.PROPERTY, use = JsonTypeInfo.Id.CLASS, property = "jsonType")
public class CsvField extends Field {

    private static final long serialVersionUID = 1L;

    private Integer column;

    public void setColumn(Integer column) {
        this.column = column;
    }

    public Integer getColumn() {
        return column;
    }

    public static CsvField cloneOf(CsvField field) {
        CsvField newField = new CsvField();
        AtlasModelFactory.copyField(field, newField, true);
        newField.setColumn(field.getColumn());
        return newField;
    }
}
