/*
 * Copyright (C) 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.syndesis.common.jaeger;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/**
 * Creates and configures a io.opentracing.Tracer object using a Jaeger impl based
 * on env configuration.
 */
@Configuration
@ConditionalOnProperty("jaeger.service.name")
@ConditionalOnClass(WebMvcConfigurerAdapter.class)
@AutoConfigureOrder(-2147483639)
public class JaegerConfiguration {

    @Value("${jaeger.service.name}")
    private String serviceName;

    @Primary
    @Bean
    public io.opentracing.Tracer jaegerTracer() {
        // use a microsecond precision clock for more accuracy as there could be span tracing less than 1ms
        return io.jaegertracing.Configuration.fromEnv(serviceName).getTracerBuilder()
            .withClock(new MicrosecondPrecisionClock()).build();
    }

}
