// Code generated by vfsgen; DO NOT EDIT.

package olm

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	pathpkg "path"
	"time"
)

// assets statically implements the virtual filesystem provided to vfsgen.
var assets = func() http.FileSystem {
	fs := vfsgen۰FS{
		"/": &vfsgen۰DirInfo{
			name:    "/",
			modTime: time.Time{},
		},
		"/alm-examples": &vfsgen۰CompressedFileInfo{
			name:             "alm-examples",
			modTime:          time.Time{},
			uncompressedSize: 402,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\x8d\xb1\x8a\xc2\x40\x10\x86\xfb\x7d\x8a\x61\xea\xe3\x8e\xb3\x4c\xe7\x33\x08\x36\x62\x31\xc9\x8e\x32\x26\xd9\x1d\x32\x9b\x80\x48\xde\x5d\x36\xc6\x20\x88\x60\x9a\x2d\xbe\xfd\xbe\x7f\x0e\x37\x07\x80\xa4\xb2\xe7\xce\x24\x06\x2c\x00\xed\x1a\x3c\x9b\xd8\xaf\xc4\xbf\xe1\xbf\xe4\x44\x1b\xfc\xc9\x5a\x2d\xc1\x67\x61\x37\x0b\x0f\xda\x72\x22\x4f\x89\xb0\x80\x3c\x06\x80\x81\x5a\xce\x1e\xa9\xa2\x03\x18\x27\xcd\x94\x2b\x84\xc5\x21\xef\x63\xb0\xa5\x01\xc0\x0b\xf1\x99\xbb\x17\x02\x80\x1c\xa8\x6c\x38\x1f\x4d\x5d\xcf\x33\x9f\xf6\xa6\xef\x3a\x50\x92\x81\x3f\x35\x27\x6a\xec\x3d\x8a\x6a\xeb\x02\xed\xcb\x46\xaa\xad\xca\xba\x2c\x45\x1f\xbf\x2a\xdc\xf3\x1d\xdd\x78\x74\xf7\x00\x00\x00\xff\xff\xc6\xcd\x43\xeb\x92\x01\x00\x00"),
		},
		"/community": &vfsgen۰DirInfo{
			name:    "community",
			modTime: time.Time{},
		},
		"/community/description": &vfsgen۰CompressedFileInfo{
			name:             "description",
			modTime:          time.Time{},
			uncompressedSize: 978,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x5c\x52\x4d\x6f\xdb\x30\x0c\xbd\xfb\x57\x10\xe9\xa5\x05\xd2\xfc\x80\x5c\xd3\xc3\x80\x01\x3b\x64\x05\x7a\x1c\x68\x89\xb6\xb9\xc9\xa2\x26\x52\x71\xb3\x61\xff\x7d\x90\x3f\xd2\xa0\x27\x9b\x8f\x1f\xe2\xe3\x7b\x0f\x0f\x0f\xf0\xfd\x1a\x3d\x29\x2b\x48\xa2\x8c\x26\xb9\xb9\x21\xac\x80\xd0\x05\x7a\xe7\x36\x10\x60\xf4\xe0\x8a\x9a\x8c\xfc\x07\xdb\x40\xfb\xda\x11\x41\xa5\x64\x47\x90\x02\x5a\x27\x79\x04\x1b\xd0\x20\x65\xb9\xb0\x27\x05\x27\x99\x80\xa3\x51\x9f\xd1\x58\x22\x38\x4c\xd8\x72\x60\x63\x52\xc0\xfa\x80\x52\xbe\xb0\xa3\x43\xd3\xbc\x0e\x77\x6b\x00\x47\x35\x0c\x61\xae\x9a\x28\x84\xfa\x75\x12\x3b\xee\x4b\x26\x05\x1b\x08\x3a\x09\x41\x26\x8e\x3d\xe8\xb6\xb3\x93\x31\x49\xa4\x68\x7a\x6c\x9e\x6f\xf0\x73\x7d\x84\xf2\x3d\x32\x92\xe1\x7d\x5c\xf8\x3e\xf2\xed\x7d\x94\xb2\x8c\x64\x03\x15\xfd\x84\xbe\x5f\xef\x01\xc1\x62\xc3\x82\x36\xf5\xb4\x5f\x64\x02\x93\x8d\x48\xf3\x36\x50\x9c\xd7\xfe\xa0\xa8\x5b\x92\x3c\x3c\x5e\xa5\xc0\x80\x17\x02\x97\x09\x8d\x7c\xbd\x4d\x69\xd5\x65\x4e\xf3\xe9\xaa\x00\x9f\xdb\x73\x89\xb1\xf2\xe7\x65\xb2\x52\x20\x57\x5b\x23\x8e\xa4\x09\x1d\x3d\xad\xd3\x00\x21\xd2\x04\xa7\x33\x48\x07\x5f\x39\xfa\x0f\xe1\x1f\x5d\x60\xf7\x6b\xee\x3f\x2d\xb5\xdf\x68\x82\xb6\x98\x49\x7c\x3a\xc0\x6b\xc5\xcf\xa0\x89\x5c\xbd\xbf\x21\x47\x05\x0c\x01\x3c\x75\x58\x82\x29\x3c\x2a\x11\xb4\x14\x64\x7a\x3a\x2c\xcc\x4f\x67\x78\x59\xb3\xcd\xda\xef\xa9\xe3\xc8\x33\x11\x56\x48\x99\xcc\xae\xa0\x3c\xa6\xd5\x5a\x18\x81\xc6\x74\xad\xa5\x13\x87\x00\x96\xb9\xef\x29\x03\x42\x8b\x4a\xdb\x9d\x66\x13\x1d\x9a\xe6\x8d\x6d\x58\x39\xa3\xf7\x12\x15\x94\x5c\xcd\xed\xa1\x28\x65\x05\xcc\x04\xd5\xa5\x55\x00\x8a\xf3\x5f\x65\xc0\x1d\xbb\xb5\x63\x61\x86\x17\xe4\x30\xa7\xd7\x39\x68\xf3\xd4\x51\x46\x8a\x56\xc7\x54\x1f\xfd\x44\xea\x29\x1f\xb7\x49\x4b\xd8\x3c\x83\x24\xdd\x40\x85\x51\x22\x9b\x64\x8e\xfd\x1e\x32\xfd\x2e\x5c\x6d\x4a\xef\x96\x11\x4e\xe7\x97\x6a\x1d\x13\x2f\xc7\x2a\xeb\x42\xbb\x86\x80\x29\x05\x76\x33\xaf\xa6\x79\xbd\x2d\xbb\x6c\xb3\x07\x25\x83\xdd\x1c\xfc\xa8\x9a\xee\x8e\xf0\x77\xb7\x94\xf8\xdd\x11\x2c\x17\xfa\xb7\x89\x7f\x3a\x1f\x9a\xff\x01\x00\x00\xff\xff\xf4\xe9\x09\x0f\xd2\x03\x00\x00"),
		},
		"/icon": &vfsgen۰CompressedFileInfo{
			name:             "icon",
			modTime:          time.Time{},
			uncompressedSize: 2133,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x55\x4d\x93\xaa\xbc\x12\xde\xdf\xbf\x72\x36\x01\xe2\xad\x71\x71\x17\x4a\x10\xf1\x4d\x47\x31\x61\x1c\xd8\x0d\x78\x0a\x89\x3a\x33\x55\x18\x43\xf2\xeb\x6f\x35\x83\x33\xe7\xa3\xea\x5d\x50\xc1\x6e\xd2\x1f\xcf\xf3\x74\xbb\x5b\x8b\xb0\x72\x4b\x5a\x1f\x06\xd3\x78\xd2\xbd\xae\xf7\xa4\x61\xef\x77\x1e\x1d\xa3\xa3\x9b\x45\xe0\x66\xf7\xe6\xda\xdc\x41\x2f\x2c\xc4\x73\x7f\xbc\x36\x5d\xb6\xae\x3e\xaa\x97\x63\x5c\x47\xed\x3c\xd3\x8b\x16\xe2\xc5\x00\x6c\xd1\x82\x5a\xd8\x4c\xd3\xa7\x2a\x7d\xbe\x36\x9e\x3e\x35\xd1\x7e\x56\xa7\xc5\x0f\x7e\x15\x7d\xe3\xc8\xf0\x33\xac\x3e\xea\xd4\xfe\x37\x0b\xf3\x08\x0e\x85\x05\x76\x9b\x4f\x3e\xf7\xed\x03\x07\x87\xe4\x57\x9f\xff\xf6\x55\xd7\x4a\x7f\xd9\xc9\xb7\xfd\xf9\x54\x1d\x56\x97\x52\xdd\xe6\x3b\xac\x71\x7d\xe9\x2b\x45\x9f\x78\xb8\xbf\x54\x6f\xf0\x63\xb7\xde\x7f\x1c\xd3\xe1\xb2\x7b\x5b\xba\x3a\xdc\x07\x65\xb4\xff\x28\xc3\xb9\x69\x82\xa7\x01\x58\x12\xbd\x04\x9b\x75\x7e\x99\x6f\xea\xb7\xfd\xa5\x8a\x36\xa7\x63\x7a\xb9\xd7\xdd\xf2\xfa\x7a\x98\x9d\xea\x78\xa9\xeb\x70\xb8\x37\xda\xde\x8f\xe9\x85\x60\x3f\xbb\xb4\x69\x5f\x0f\xf9\x3c\x3b\x0f\xa7\x9f\x87\x67\xf7\xe2\x93\x2e\x4b\xf7\xa7\x63\x9a\xdc\xea\xeb\xea\x56\x29\xd2\xa9\x74\x35\xab\x5e\xb2\x16\x64\xf6\x63\x97\x8a\x8f\xe6\x2a\xfa\x4a\x2e\x75\x9d\xae\x3c\xe2\x5c\x86\x83\xe7\x0a\xef\x09\xba\x93\x59\x00\x71\xd6\x96\xd1\x79\x9e\xe9\xc2\x66\xdd\xd2\x3d\x6c\xc7\xf5\xe6\x54\xbf\x89\x6b\x1d\x6d\x6e\x3b\xb9\x21\xcd\x75\x65\x9a\x70\x38\x1d\xd3\xe2\x9d\xab\xcc\x72\xdd\x0c\x19\x2b\xec\x3f\x72\xe9\xea\x68\x3f\xd9\xf3\xe0\x1f\x99\xdd\x77\x7a\xb0\xe5\xcb\xfe\x3d\x4b\x45\x5f\xbe\x08\xbf\x93\x1b\x5d\xaf\xe1\x06\x5d\xd6\x56\x8c\x74\x4a\xb5\x01\xd7\x10\x72\x96\x10\xae\x4b\x92\xab\xc2\x72\x86\xcf\xa2\x87\xd8\x0e\x0f\x3b\x67\x9f\xdf\x1d\xba\x5f\x63\x62\xff\xc4\x83\xb4\x1e\x24\xf5\xe2\x9a\x0c\x5c\x9f\x09\x67\x89\xd9\xaa\x1c\xef\x5b\xce\x92\x1b\x38\x1a\x42\x47\xcc\x96\x9d\x8d\x60\x80\xcf\xc3\xd7\x73\x5d\x78\x2e\x29\x11\xb1\xf5\x5c\x83\xe3\x0c\x0c\xf8\x6c\xf2\x2f\x7a\xe8\x28\x05\x49\xa3\x5c\x52\x02\x0e\x9f\xc9\x3e\xe6\x9c\xf2\x5e\xde\x3b\x8e\x5a\x4b\x57\xe4\x35\xfe\x13\x5f\xe8\xa6\x3a\x23\x81\x75\x38\x4b\x44\x4c\x23\x71\x06\xfc\x3d\x40\x67\xc9\x18\x23\xb6\x11\x38\xeb\x40\xda\x50\x74\xd4\x43\x67\x1d\x1c\x10\xa7\xb1\x36\xcb\x55\x6e\x84\x3a\xf7\xe0\xa8\x17\x92\x84\x9c\x95\x66\xcb\xda\x1b\xd7\xf9\xd8\x2f\xb0\xf2\x06\x92\x3a\x70\x76\xe0\x7a\x41\xb9\x4a\x8c\xd0\xd0\x43\x02\x81\x70\xd4\x89\xd8\x3a\x11\xd3\x41\x74\x36\x10\x92\xd2\x6d\x3c\xe6\x0a\xc0\x51\x37\xbd\x93\x31\xf6\xf4\x2e\x1c\xa5\x22\xb6\x44\x48\x3a\x6c\x63\xeb\xb7\x72\x7a\x4f\xe1\x26\x62\x1a\x08\xc4\x41\x15\x06\x7c\x73\x03\xb5\xc0\xda\x6e\x42\xd2\x80\x2b\xe4\xab\x71\x9c\x65\x06\xd4\xd9\x08\x5d\x8c\x35\x73\x95\xe0\x19\x08\x49\x1c\xd7\xe5\x50\x4a\xc4\x62\xc4\x63\xe2\x9a\x18\x31\xf6\xd3\x4c\x1c\x94\x9f\xbd\x76\x5f\x7e\xcf\x63\x4a\xb7\x45\xeb\x84\xa3\x1e\x0e\x09\x6a\xe3\xc1\xd3\x8d\xeb\x92\x72\x9d\xd1\x1a\xe3\x28\x30\x42\x89\x0c\x74\x66\x40\xaf\x4e\x5c\x17\x64\x7c\x3e\x35\x65\xb9\xa4\x7e\x8b\x58\x5c\x2d\x6a\x63\x26\x24\x72\x7f\x0e\x4a\x49\x83\xb1\xb7\x07\xf7\xb1\x35\xe0\x5b\xb3\x55\xab\x77\xd4\x5e\x8d\xb6\xa4\x75\x5b\x49\x23\x38\x80\x11\x9d\x0d\xb9\xce\x50\xbb\x46\xf8\xa2\x07\x9d\xf5\xa0\x4a\x23\x18\x9e\x8d\x01\x75\xe9\x31\x17\x74\x36\x50\x2c\x27\x5c\x43\xc4\x59\x43\xb9\xce\xc3\x12\xf1\x90\xf6\x17\x9d\xaf\xde\x45\x4c\x67\x7f\xd9\xd5\x0a\x63\x84\x20\x89\x43\x3c\xc0\x11\x03\xaa\x40\xac\x29\x1c\x20\xe4\x2a\x33\xc2\xb7\xfd\x56\x92\x80\xeb\x12\x6b\x09\xb9\x4e\x66\x1c\xeb\xf0\x05\x6a\x22\xd8\x4a\x8b\x98\x3b\xfc\x16\x58\xd1\x8b\x8e\x52\xe1\x90\x87\x45\xc8\x47\xcc\xf1\x2c\x51\xeb\x81\x90\x96\x72\xdd\x10\xce\x8a\x1e\x14\x18\xd0\x1b\x10\x1a\x8c\xf0\xd0\x0b\x7f\x3a\x81\xc4\x5a\x27\x1c\x91\x0f\xfc\xad\xc1\xbd\xb2\xdc\x08\xbd\xff\xd3\x3f\xc3\x7a\x85\xdf\x83\xf0\x79\x2f\x74\x66\xc4\x75\xd4\x0f\x05\x47\x22\xae\x73\x3f\xce\x2a\x83\x1b\x8c\x5a\x1a\x35\x42\x40\x92\x41\x90\xdf\xf8\xed\x85\x6f\x46\x3d\x0b\xcc\xe3\xab\x57\xa5\x60\xe0\x0c\x30\x37\x62\xf9\x39\xef\x92\xce\xbe\xb8\x93\xc4\x8f\x3d\xa3\xd6\xff\x9e\x5d\xd4\xc8\x34\x3b\xd3\xbc\xbb\x91\xa7\x07\xee\x8e\xeb\x76\xe0\xfa\xb8\x1c\x6b\x1c\xeb\x7c\xf0\xf4\x9d\xf7\xf7\x5d\xf4\xfb\x7e\x13\xf1\x63\xbf\xe5\xc8\x87\xe7\xac\xc0\xb9\x8c\x72\x8f\x77\xf3\x90\xb3\x22\xe0\xfa\x8c\x5a\xb7\x5c\x63\xcc\xdc\x72\x9d\x10\xce\xb2\x19\xee\x53\xce\xc0\x73\xdd\x52\xc9\x12\xca\x75\x19\x28\x36\xee\xd9\x80\x33\xf8\x53\x3b\x46\xe8\xd6\x80\x3e\xbd\x8b\x2b\xe0\xee\x34\x5b\xac\x73\xcc\x89\x77\x50\x8b\x79\x0f\x7a\x61\xe0\x9a\xf8\x69\xd7\x3c\xce\x47\x0c\xc2\x75\x8e\x58\x79\xf1\xfc\x6f\xbb\x2c\x7f\xec\xb2\x00\x62\xe4\xc9\x92\xed\xb8\x77\x2d\x6a\xb2\xff\xd4\x64\x32\x00\x6b\x0d\x74\xf6\x71\x7e\x69\x59\xc4\x64\x9a\xc3\x04\x7b\x9c\x7d\x9f\x0f\x6c\xb3\x71\x8f\x6d\x13\x08\x90\x33\xd1\x8d\x3b\x29\xe2\xac\x08\x3f\xb9\x42\x2c\x0b\x3a\xfe\x3f\xe8\x1c\x31\x9b\x7d\xf3\x60\xef\x95\xa7\x4f\x3c\x12\x61\xe5\xe9\xff\xfe\xf3\xff\x00\x00\x00\xff\xff\x6d\xf0\xaa\xc4\x55\x08\x00\x00"),
		},
		"/productized": &vfsgen۰DirInfo{
			name:    "productized",
			modTime: time.Time{},
		},
		"/productized/description": &vfsgen۰CompressedFileInfo{
			name:             "description",
			modTime:          time.Time{},
			uncompressedSize: 2608,

			compressedContent: []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\x56\x5d\x6f\x1b\xb9\x0e\x7d\x9f\x5f\x41\xa4\x2f\x29\xe0\x71\x70\xef\x7d\x33\x90\x87\xdc\x24\x45\x8b\x6d\x9b\xc0\x4e\x51\x2c\x76\x17\xa9\xac\xe1\xcc\xb0\xd5\x88\xb3\x12\x65\xd7\xbb\xd8\xff\xbe\xa0\xe6\x23\x4e\xbc\xc5\x3e\xd9\xd2\x90\xd4\xe1\xe1\x21\xa5\x37\x29\x22\xdc\x79\x47\x1e\x81\x22\x18\xa8\x1d\x7e\xa7\xad\x43\x30\xbe\x02\x9b\xa2\x70\x47\x7f\x98\xad\xc3\x05\x70\x8f\x1e\x22\xa7\x60\x11\x7a\x67\xa4\xe6\xd0\x81\xb4\x46\xa0\x0f\xbc\xa3\x0a\x23\x58\x0e\x08\xe4\x05\x9b\x60\x84\xd8\x83\x35\xbd\xd9\x92\x23\x21\x8c\x60\xf4\x80\x88\x61\x47\x16\x97\x45\xf1\xd0\x52\xd4\xa0\xc1\x08\x07\x20\x1f\xc5\x38\x97\xad\xf6\xe8\x9c\xfe\x5a\xf6\x35\x35\x29\x60\x04\x69\x11\x6a\x76\x8e\xf7\xe4\x1b\x38\x86\x6d\xb9\xeb\xd9\xa3\x97\xb8\x2a\x4a\x88\x07\x5f\x61\xa4\x58\xea\x39\x18\x8e\x77\x3a\x14\x73\xbc\x4e\x74\xbc\xaa\xb6\xc7\xab\x3e\x70\x87\xd2\x62\x8a\x2f\x76\xbf\x1f\x8e\x37\xd8\x24\x69\x87\xdd\xe2\xd5\xab\x57\xf0\x7f\xac\x95\x81\x03\x27\xd8\x62\x43\xbe\xf8\x99\x13\x74\x29\xca\x53\x2a\xa0\x2e\xe8\x85\xec\xc0\x90\x30\xac\xb1\x82\xb7\x26\xdb\x88\x21\x8f\x01\x02\x36\x14\x25\x1c\x60\xfb\x14\xd0\x1a\x0f\xd4\xf5\x1c\x24\xd7\x46\x19\x50\x52\x26\xe7\x81\x92\x1e\xfd\xa6\xa5\x5a\xe0\x5d\x67\x1a\x84\x8d\x04\x34\x5d\x5c\xc2\x9b\x4c\x5d\x26\x39\x24\x9b\x0f\x6e\x68\x87\x1e\xb6\xa8\xfb\xc2\x47\x00\x35\xea\x08\x60\x86\x78\x0a\x6d\x59\x14\xff\x59\xc2\x7b\x6e\x80\xb2\x85\x7a\x3d\x1d\xbf\xc9\xec\xe7\x8a\x7b\x30\x55\x47\x7e\x08\xc7\x61\xa1\x9b\x43\x25\x57\x05\x00\xc0\x97\x2f\x5f\xf2\x2f\x5b\x70\xdc\x90\x87\x32\x41\x3c\x44\xc1\x6e\x95\x1d\x67\xa3\xff\xfe\xf8\xb8\x3e\xf0\x57\xb4\x02\xfb\x16\x47\xb6\xf6\xe4\x1c\x6c\x71\x92\x95\x8a\x46\x5d\x26\xb9\x2d\x5f\x1e\x3d\x45\xa8\x53\xc4\x92\xb3\xb2\x66\x93\xff\x2d\xe1\x3a\xa0\x11\x04\x03\x15\xdb\x6f\x18\xca\xb9\x40\x11\x6d\x40\x81\x14\xf5\x04\x24\x69\x31\xcc\x25\xb9\xce\xed\x83\x01\xee\x39\x88\x71\x60\xac\xe5\xe4\x05\xf8\xc9\xe4\x06\x77\xe8\x14\x14\xdc\x07\x6e\x82\xe9\x66\x23\x1b\xb0\x52\x99\x18\x17\x4f\xc0\xda\x01\xcd\x78\xf6\x09\xa4\x59\xae\xc9\xb9\x72\x34\xfa\x35\xfb\x02\x94\xe5\x68\x3e\xf4\xc7\xe5\x5c\xce\x80\x55\x6b\x64\x49\x7c\x6a\x9a\x22\x06\x6f\x3a\xbc\xbc\xfe\xb4\x79\xb8\xfb\x70\xbb\x7e\xbc\xbf\x5b\x3f\x5c\xbd\x7f\xfc\xb4\xb9\x5d\x7f\xbc\xfa\x70\x7b\xea\xd2\x9b\x18\xf7\x1c\xaa\x13\x97\xfb\xab\xcd\xe6\xf3\xdd\xfa\xe6\xd4\x05\x3b\x43\xee\xf2\xf6\xc3\xd5\xbb\xf7\x8f\x57\x37\x37\xeb\xdb\xcd\xe6\x59\xde\x1f\xef\x1e\x6e\x57\xa0\x0d\xe5\x11\xab\x2c\xca\x7f\x29\x0a\x79\xc0\x1d\x86\x03\x78\xdc\x83\x26\x10\x7b\x63\x71\x14\x89\xaa\x81\x72\x93\xc4\xa1\x49\x20\x60\xa4\x6a\x18\x7c\xfb\x96\x6c\x9b\x5b\xec\x94\x9f\x65\x91\xe1\xbc\xab\xb3\xce\x2a\x06\xcf\x02\x7b\x8a\xad\x42\x52\x97\x03\xa7\xa7\x02\x4f\xe5\x9c\x38\xcc\xe1\x27\x76\x8e\x92\x50\x38\x03\xec\x05\x90\xe8\x2c\x0e\x68\xb9\xeb\xd0\x57\xcf\x93\xf5\xa7\x03\xe4\x1b\xfa\x51\x80\x06\x7e\x39\x22\x21\x0f\xda\x09\xc1\x6f\xe7\xad\x48\x1f\x57\x17\x17\xc6\x5a\x8c\x71\x4a\xc8\x72\x77\x21\x18\xba\x58\x6e\x4d\xc4\x6a\x26\xf1\xe2\xf5\x72\x98\x69\x6f\x87\xf9\x30\x36\x52\x51\xc2\xe7\x16\xfd\xb3\x66\x52\xb4\xe3\x67\xac\xe0\x5c\x69\x69\xcd\x0e\x47\xc8\x95\x0e\xfd\xb4\x8d\x36\x50\x9f\x01\x2b\x03\x2f\xdd\x43\xf2\x5e\x13\x20\x3f\x32\xe1\xd0\xaa\xeb\x5c\xb5\xd7\xd9\xed\x78\x1c\x4e\xc5\xd7\xe2\x5e\xaf\x81\x6b\xf8\x89\x7c\x05\x9b\x51\xfd\x0b\x98\x71\x08\x83\x23\xff\xed\x88\xe3\x19\xda\x78\x5e\x1f\x70\x47\x9c\xa2\x7e\x9e\x46\xde\x33\x88\x2f\xc8\x5c\x16\xaa\x4a\xb6\x63\xb8\x38\xc4\x7f\xba\x16\x66\xb7\x7f\x6a\xc5\xb2\xac\x39\x5c\xea\x4e\x8e\x52\x94\x4f\xd3\xe5\x07\xb9\xc0\xb9\x75\x64\x87\x04\x46\xdb\x8f\xb8\x87\x6d\x12\x61\xff\x7a\x09\x0f\xba\xbf\x86\xd8\xa3\x9d\x26\x75\x04\xe3\x1c\x54\x58\x9b\xe4\x24\xc2\x79\x44\x1c\x66\xfd\x54\xd6\xeb\x35\xdc\x8c\x5f\x8b\xd1\xbf\xc2\x9a\x3c\xe5\xfc\x29\x2a\x27\x22\x07\x88\xd4\xf5\xe3\x73\xc0\x78\xc0\xae\x3f\xa8\x69\x1e\xaf\x12\xa8\x69\x74\xca\x83\x4a\x67\x92\x40\x56\xe5\xb2\x28\x3e\x93\xb4\x23\xbd\xa6\xaa\xd8\xcf\xe4\x2e\x72\x33\x44\x30\x7a\x19\xea\x53\x43\x18\xd0\xe7\x7f\x9a\x01\xd5\x64\x47\x8f\x21\x33\xb3\x33\xe4\xf2\xe7\x31\x8e\x91\x1c\xb5\xe3\x0e\xbd\x68\x18\xbd\xf8\xbf\x1a\x6c\x30\xac\xa6\x48\xc3\xb2\x28\x81\xfb\x38\x6d\x46\xe8\xd8\x93\x70\x20\xdf\x2c\x20\xe0\xef\x89\xf4\x69\x81\xdf\x25\x18\xb8\x5e\xdf\xe8\x5d\x2f\x5c\xf1\x4a\x15\x3b\xa4\xad\x4b\x30\x7d\xef\xc6\x6e\x2b\x8a\x87\x19\xec\x80\x66\x01\x11\x05\xce\xf2\xe2\x51\xe5\x7a\xb6\x82\x3f\xcf\x06\x93\xea\x6c\x05\x12\x12\xfe\x35\xe9\xec\x7a\xbd\x2c\x8a\x37\xac\x94\x75\x2a\xe4\x0a\xc5\x90\x36\x8d\xc6\xe0\xfa\xf8\x7e\x8e\x03\xe5\xf9\x79\xe3\x50\x74\x12\xd5\x18\xd0\x5b\x54\xc3\xe1\xb6\x06\xce\x1d\x15\x17\x45\xef\xd0\xc4\xd1\x66\x12\x6f\x1f\xb8\x4a\x36\xdf\x0f\x49\x99\x1a\xc6\x85\x11\xf8\xf1\x20\x78\x66\x7a\x81\xbe\x4c\xf1\x22\x60\xf5\xd8\x1a\x79\xd4\x9b\xb1\xf8\x3b\x00\x00\xff\xff\x2c\xd0\x52\xb9\x30\x0a\x00\x00"),
		},
	}
	fs["/"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/alm-examples"].(os.FileInfo),
		fs["/community"].(os.FileInfo),
		fs["/icon"].(os.FileInfo),
		fs["/productized"].(os.FileInfo),
	}
	fs["/community"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/community/description"].(os.FileInfo),
	}
	fs["/productized"].(*vfsgen۰DirInfo).entries = []os.FileInfo{
		fs["/productized/description"].(os.FileInfo),
	}

	return fs
}()

type vfsgen۰FS map[string]interface{}

func (fs vfsgen۰FS) Open(path string) (http.File, error) {
	path = pathpkg.Clean("/" + path)
	f, ok := fs[path]
	if !ok {
		return nil, &os.PathError{Op: "open", Path: path, Err: os.ErrNotExist}
	}

	switch f := f.(type) {
	case *vfsgen۰CompressedFileInfo:
		gr, err := gzip.NewReader(bytes.NewReader(f.compressedContent))
		if err != nil {
			// This should never happen because we generate the gzip bytes such that they are always valid.
			panic("unexpected error reading own gzip compressed bytes: " + err.Error())
		}
		return &vfsgen۰CompressedFile{
			vfsgen۰CompressedFileInfo: f,
			gr:                        gr,
		}, nil
	case *vfsgen۰DirInfo:
		return &vfsgen۰Dir{
			vfsgen۰DirInfo: f,
		}, nil
	default:
		// This should never happen because we generate only the above types.
		panic(fmt.Sprintf("unexpected type %T", f))
	}
}

// vfsgen۰CompressedFileInfo is a static definition of a gzip compressed file.
type vfsgen۰CompressedFileInfo struct {
	name              string
	modTime           time.Time
	compressedContent []byte
	uncompressedSize  int64
}

func (f *vfsgen۰CompressedFileInfo) Readdir(count int) ([]os.FileInfo, error) {
	return nil, fmt.Errorf("cannot Readdir from file %s", f.name)
}
func (f *vfsgen۰CompressedFileInfo) Stat() (os.FileInfo, error) { return f, nil }

func (f *vfsgen۰CompressedFileInfo) GzipBytes() []byte {
	return f.compressedContent
}

func (f *vfsgen۰CompressedFileInfo) Name() string       { return f.name }
func (f *vfsgen۰CompressedFileInfo) Size() int64        { return f.uncompressedSize }
func (f *vfsgen۰CompressedFileInfo) Mode() os.FileMode  { return 0444 }
func (f *vfsgen۰CompressedFileInfo) ModTime() time.Time { return f.modTime }
func (f *vfsgen۰CompressedFileInfo) IsDir() bool        { return false }
func (f *vfsgen۰CompressedFileInfo) Sys() interface{}   { return nil }

// vfsgen۰CompressedFile is an opened compressedFile instance.
type vfsgen۰CompressedFile struct {
	*vfsgen۰CompressedFileInfo
	gr      *gzip.Reader
	grPos   int64 // Actual gr uncompressed position.
	seekPos int64 // Seek uncompressed position.
}

func (f *vfsgen۰CompressedFile) Read(p []byte) (n int, err error) {
	if f.grPos > f.seekPos {
		// Rewind to beginning.
		err = f.gr.Reset(bytes.NewReader(f.compressedContent))
		if err != nil {
			return 0, err
		}
		f.grPos = 0
	}
	if f.grPos < f.seekPos {
		// Fast-forward.
		_, err = io.CopyN(ioutil.Discard, f.gr, f.seekPos-f.grPos)
		if err != nil {
			return 0, err
		}
		f.grPos = f.seekPos
	}
	n, err = f.gr.Read(p)
	f.grPos += int64(n)
	f.seekPos = f.grPos
	return n, err
}
func (f *vfsgen۰CompressedFile) Seek(offset int64, whence int) (int64, error) {
	switch whence {
	case io.SeekStart:
		f.seekPos = 0 + offset
	case io.SeekCurrent:
		f.seekPos += offset
	case io.SeekEnd:
		f.seekPos = f.uncompressedSize + offset
	default:
		panic(fmt.Errorf("invalid whence value: %v", whence))
	}
	return f.seekPos, nil
}
func (f *vfsgen۰CompressedFile) Close() error {
	return f.gr.Close()
}

// vfsgen۰DirInfo is a static definition of a directory.
type vfsgen۰DirInfo struct {
	name    string
	modTime time.Time
	entries []os.FileInfo
}

func (d *vfsgen۰DirInfo) Read([]byte) (int, error) {
	return 0, fmt.Errorf("cannot Read from directory %s", d.name)
}
func (d *vfsgen۰DirInfo) Close() error               { return nil }
func (d *vfsgen۰DirInfo) Stat() (os.FileInfo, error) { return d, nil }

func (d *vfsgen۰DirInfo) Name() string       { return d.name }
func (d *vfsgen۰DirInfo) Size() int64        { return 0 }
func (d *vfsgen۰DirInfo) Mode() os.FileMode  { return 0755 | os.ModeDir }
func (d *vfsgen۰DirInfo) ModTime() time.Time { return d.modTime }
func (d *vfsgen۰DirInfo) IsDir() bool        { return true }
func (d *vfsgen۰DirInfo) Sys() interface{}   { return nil }

// vfsgen۰Dir is an opened dir instance.
type vfsgen۰Dir struct {
	*vfsgen۰DirInfo
	pos int // Position within entries for Seek and Readdir.
}

func (d *vfsgen۰Dir) Seek(offset int64, whence int) (int64, error) {
	if offset == 0 && whence == io.SeekStart {
		d.pos = 0
		return 0, nil
	}
	return 0, fmt.Errorf("unsupported Seek in directory %s", d.name)
}

func (d *vfsgen۰Dir) Readdir(count int) ([]os.FileInfo, error) {
	if d.pos >= len(d.entries) && count > 0 {
		return nil, io.EOF
	}
	if count <= 0 || count > len(d.entries)-d.pos {
		count = len(d.entries) - d.pos
	}
	e := d.entries[d.pos : d.pos+count]
	d.pos += count
	return e, nil
}
