/*
 * Copyright 2013 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */
package org.jbosson.plugins.fuse;

import org.rhq.core.pluginapi.event.log.LogFileEventResourceComponentHelper;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.JMXServerComponent;

/**
 * Adds log file tracking support.
 *
 * @author dbokde
 */
public class FuseServerComponent<T extends ResourceComponent<?>> extends JMXServerComponent<T> {

    // needed for log file tracking
    private LogFileEventResourceComponentHelper logFileEventDelegate;

    @Override
    public void start(ResourceContext context) throws Exception {
        super.start(context);

        // start log file tracking
        logFileEventDelegate = new LogFileEventResourceComponentHelper(context);
        logFileEventDelegate.startLogFileEventPollers();
    }

    @Override
    public void stop() {

        // stop log file tracking
        logFileEventDelegate.stopLogFileEventPollers();

        super.stop();
    }

}
