/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerConsumer
extends DefaultConsumer {
    private static final transient Log LOG = LogFactory.getLog(TimerConsumer.class);
    private final TimerEndpoint endpoint;
    private TimerTask task;

    public TimerConsumer(TimerEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.task = new TimerTask(){

            public void run() {
                TimerConsumer.this.sendTimerExchange();
            }
        };
        Timer timer = this.endpoint.getTimer();
        this.configureTask(this.task, timer);
    }

    protected void doStop() throws Exception {
        this.task.cancel();
        this.task = null;
    }

    protected void configureTask(TimerTask task, Timer timer) {
        if (this.endpoint.isFixedRate()) {
            if (this.endpoint.getTime() != null) {
                timer.scheduleAtFixedRate(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.scheduleAtFixedRate(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
            }
        } else if (this.endpoint.getTime() != null) {
            if (this.endpoint.getPeriod() > 0L) {
                timer.schedule(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.schedule(task, this.endpoint.getTime());
            }
        } else if (this.endpoint.getPeriod() > 0L) {
            timer.schedule(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
        } else {
            timer.schedule(task, this.endpoint.getDelay());
        }
    }

    protected void sendTimerExchange() {
        Exchange exchange = this.endpoint.createExchange();
        exchange.setProperty("CamelTimerName", this.endpoint.getTimerName());
        exchange.setProperty("CamelTimerTime", this.endpoint.getTime());
        exchange.setProperty("CamelTimerPeriod", this.endpoint.getPeriod());
        Date now = new Date();
        exchange.setProperty("CamelTimerFiredTime", now);
        exchange.getIn().setHeader("firedTime", now);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Timer " + this.endpoint.getTimerName() + " is firing"));
        }
        try {
            this.getProcessor().process(exchange);
            if (exchange.getException() != null) {
                this.handleException(exchange.getException());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }
}

