#!/bin/sh
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.


# Use this script to generate the downstream branch:
# Usage example:

# ./scripts/new-down ENTMQBR-XXX commit1 commit2... commitN

git fetch downstream
git checkout downstream/2.7.0.jbossorg-x -B $1

for i in "${@:2}"
do
    echo "$i"
    git cherry-pick -x $i
    OLD_MSG=$(git log --format=%B -n1)
    git commit --amend -m"$OLD_MSG" -m"downstream: $1"
done

git push origin-rh $1 -f
