REM
REM Licensed to the Apache Software Foundation (ASF) under one
REM or more contributor license agreements.  See the NOTICE file
REM distributed with this work for additional information
REM regarding copyright ownership.  The ASF licenses this file
REM to you under the Apache License, Version 2.0 (the
REM "License"); you may not use this file except in compliance
REM with the License.  You may obtain a copy of the License at
REM 
REM   http://www.apache.org/licenses/LICENSE-2.0
REM 
REM Unless required by applicable law or agreed to in writing,
REM software distributed under the License is distributed on an
REM "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
REM KIND, either express or implied.  See the License for the
REM specific language governing permissions and limitations
REM under the License.
REM
REM Build the AMQP.Net Lite SDK from source.
REM Execute this script from directory <git-checkout-root>.
REM
REM This script requires:
REM  * Visual Studio 2017
REM  * doxygen
REM  * 7zip

setlocal
GOTO RunThis

::
:: Install example code into dotnetcore examples dir
:: %1 - install root
:: %2 - source examples intermediate dir
:: %3 - name
:: %4 - optional extra file
:: %5 - dotnetcore version (2 or 3)
::
:InstallThis
SET INSTALL_PREFIX=%1
SET CORE_VER=%2
SET INTR=%3
SET NAME=%4
SET XTRA=%5

mkdir                                      %INSTALL_PREFIX%\%NAME%
copy  SDK\examples\%INTR%\%NAME%\%NAME%.cs %INSTALL_PREFIX%\%NAME%\%NAME%.cs
copy  core-examples%CORE_VER%.csproj       %INSTALL_PREFIX%\%NAME%\%NAME%.csproj
IF DEFINED XTRA (copy  SDK\examples\%INTR%\%NAME%\%XTRA%.cs %INSTALL_PREFIX%\%NAME%\%XTRA%.cs)
GOTO :EOF

:InstallProg
SET INSTALL_PREFIX=%1
SET CORE_VER=%2
SET INTR=%3
SET NAME=%4
SET XTRA=%5

mkdir                                       %INSTALL_PREFIX%\%NAME%
copy  SDK\examples\%INTR%\%NAME%\program.cs %INSTALL_PREFIX%\%NAME%\%NAME%.cs
copy  core-examples%CORE_VER%.csproj        %INSTALL_PREFIX%\%NAME%\%NAME%.csproj
IF DEFINED XTRA (copy  SDK\examples\%INTR%\%NAME%\%XTRA%.cs %INSTALL_PREFIX%\%NAME%\%XTRA%.cs)
GOTO :EOF

:InstallExamples
SET INSTALL_PREFIX=%1
SET CORE_VER=%2
CALL :InstallThis %EX% %CORE_VER% HelloWorld     HelloWorld-async
CALL :InstallThis %EX% %CORE_VER% HelloWorld     HelloWorld-robust
CALL :InstallThis %EX% %CORE_VER% HelloWorld     HelloWorld-simple
CALL :InstallThis %EX% %CORE_VER% Interop        Interop.Client
CALL :InstallThis %EX% %CORE_VER% Interop        Interop.Server
CALL :InstallThis %EX% %CORE_VER% Interop        Interop.Drain Interop.Drain.Options
CALL :InstallThis %EX% %CORE_VER% Interop        Interop.Spout Interop.Spout.Options
CALL :InstallProg %EX% %CORE_VER% PeerToPeer     PeerToPeer.Client
CALL :InstallProg %EX% %CORE_VER% PeerToPeer     PeerToPeer.Server
CALL :InstallThis %EX% %CORE_VER% Reconnect      ReconnectSender
GOTO :EOF

:RunThis
REM When VsDevCmd.bat exits this is supposed to be our cwd.
set "VSCMD_START_DIR=%CD%"

REM Root the builds in the R:\ drive so that none of the
REM build file hierarchy bleeds out in the shippable files.
set CURDRIVE=%~d0
subst /d R:
subst R: .
R:

REM Suppress VS2017 sending telemetry to Microsoft
SET DOTNET_CLI_TELEMETRY_OPTOUT=1

REM wake up vs2017 msbuild
IF EXIST "c:\Program Files (x86)\Microsoft Visual Studio\2017\Professional\Common7\Tools\VsDevCmd.bat" (
    call "c:\Program Files (x86)\Microsoft Visual Studio\2017\Professional\Common7\Tools\VsDevCmd.bat"
) ELSE (
    call "N:\Program Files (x86)\Microsoft Visual Studio\2017\Professional\Common7\Tools\VsDevCmd.bat"
)
@echo on
 
REM Recover current working directory
R:
CD
DIR
SUBST

REM Work around some undocumented behavior. MsBuild apparently
REM lets environment variable 'version' override the version in the
REM csproj file.
SET BREWVERSION=%version%
SET version=2.3.0.0

REM DEBUG
DIR /S dotnetcore

REM compile
dotnet pack dotnetcore\AMQ-dotnet\amq-dotnet.csproj ^
       /p:Title=AMQ-dotnet ^
       /p:Authors="Azure/amqpnetlite contributors" ^
       /p:Description="A lightweight AMQP 1.0 library for dotnet core 2 and 3 (netstandard2.0)"

REM DEBUG
DIR /S dotnetcore

IF ERRORLEVEL 1 EXIT /b 1

REM Restore the brew-level version
SET version=%BREWVERSION%

REM Restore normal build directory structure
%CURDRIVE%
pwd
dir

REM Create install root
set INSTALL_FOLDER=amq-dotnet-%1-core-sdk
mkdir %INSTALL_FOLDER%
mkdir %INSTALL_FOLDER%\bin
mkdir %INSTALL_FOLDER%\doc
mkdir %INSTALL_FOLDER%\nupkg

REM Install the mission code
xcopy /s dotnetcore\AMQ-dotnet\bin\Debug\*.dll   %INSTALL_FOLDER%\bin\
xcopy /s dotnetcore\AMQ-dotnet\bin\Debug\*.pdb   %INSTALL_FOLDER%\bin\
xcopy /s dotnetcore\AMQ-dotnet\bin\Debug\*.xml   %INSTALL_FOLDER%\bin\
xcopy /s dotnetcore\AMQ-dotnet\bin\Debug\*.json  %INSTALL_FOLDER%\bin\
xcopy /s dotnetcore\AMQ-dotnet\bin\Debug\*.nupkg %INSTALL_FOLDER%\nupkg\

REM extract doxygen script from SDK
pushd SDK
move amqpnetlite-doxygen-config.txt ..
popd

REM run doxygen; install result
doxygen amqpnetlite-doxygen-config.txt
if ERRORLEVEL 1 exit /b 1
xcopy /s doxygen-html %INSTALL_FOLDER%\doc
IF ERRORLEVEL 1 EXIT /b 1

REM construct examples
mkdir %INSTALL_FOLDER%\examples
mkdir %INSTALL_FOLDER%\examples\netcoreapp2
mkdir %INSTALL_FOLDER%\examples\netcoreapp3

set "EX=%INSTALL_FOLDER%\examples\netcoreapp2"
CALL :InstallExamples %EX% 2

set "EX=%INSTALL_FOLDER%\examples\netcoreapp3"
CALL :InstallExamples %EX% 3

REM Install readme files
COPY README-core.md          %INSTALL_FOLDER%\README.md
COPY README-core-examples.md %INSTALL_FOLDER%\examples\README.md

REM create shippable zip file
mkdir tmp-core
move %INSTALL_FOLDER% tmp-core
7z a amq-dotnet-%1-core-sdk.zip .\tmp-core\*
IF ERRORLEVEL 1 EXIT /b 1

REM Done

endlocal
