#!/bin/bash
# ----------------------------------------------------------------------------
# Copyright 2021 The Netty Project
#
# The Netty Project licenses this file to you under the Apache License,
# version 2.0 (the "License"); you may not use this file except in compliance
# with the License. You may obtain a copy of the License at:
#
#   https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
# ----------------------------------------------------------------------------
set -e

if [ "$#" -ne 3 ]; then
    echo "Expected release.properties file, repository name and branch"
    exit 1
fi

TAG=$(grep scm.tag= "$1" | cut -d'=' -f2)
git remote set-url origin git@github.com:"$2".git
git fetch
git checkout "$3"
./mvnw -B --file pom.xml release:rollback
git push origin :"$TAG"
