#!/bin/sh
# Openshift Interconnect launch script

export HOSTNAME_IP_ADDRESS=$(hostname -i)

EXT=${QDROUTERD_CONF_TYPE:-conf}
CONFIG_FILE=${AMQ_HOME}/etc/qdrouterd.${EXT}

${AMQ_HOME}/bin/configure_interconnect.sh ${AMQ_HOME} $CONFIG_FILE

if [ -f $CONFIG_FILE ]; then
    ARGS="-c $CONFIG_FILE"
fi

if [[ $QDROUTERD_DEBUG = "gdb" ]]; then
    exec gdb -batch -ex "run" -ex "bt" --args qdrouterd $ARGS
elif [[ $QDROUTERD_DEBUG = "valgrind" ]]; then
    exec valgrind qdrouterd $ARGS
else
    exec qdrouterd $ARGS
fi
