/*
 * Copyright 2017-2018, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

package io.enmasse.controller.common;

/**
 * Template parameters that are dynamically set by the address space controller.
 */
public interface TemplateParameter {
    String ADDRESS_SPACE = "ADDRESS_SPACE";
    String ADDRESS_SPACE_NAMESPACE = "ADDRESS_SPACE_NAMESPACE";

    String CONSOLE_SECRET = "CONSOLE_SECRET";
    String MESSAGING_SECRET = "MESSAGING_SECRET";
    String MQTT_SECRET = "MQTT_SECRET";

    String AUTHENTICATION_SERVICE_HOST = "AUTHENTICATION_SERVICE_HOST";
    String AUTHENTICATION_SERVICE_PORT = "AUTHENTICATION_SERVICE_PORT";
    String AUTHENTICATION_SERVICE_CA_CERT = "AUTHENTICATION_SERVICE_CA_CERT";
    String AUTHENTICATION_SERVICE_CLIENT_SECRET = "AUTHENTICATION_SERVICE_CLIENT_SECRET";
    String AUTHENTICATION_SERVICE_SASL_INIT_HOST = "AUTHENTICATION_SERVICE_SASL_INIT_HOST";
    String AUTHENTICATION_SERVICE_OAUTH_URL = "AUTHENTICATION_SERVICE_OAUTH_URL";
    String AUTHENTICATION_SERVICE_KC_IDP_HINT = "AUTHENTICATION_SERVICE_KC_IDP_HINT";
    String INFRA_UUID = "INFRA_UUID";
    String ADDRESS_SPACE_ADMIN_SA = "ADDRESS_SPACE_ADMIN_SA";
    String ADDRESS_SPACE_PLAN = "ADDRESS_SPACE_PLAN";

    String INFRA_NAMESPACE = "INFRA_NAMESPACE";
    String BROKER_MEMORY_LIMIT = "BROKER_MEMORY_LIMIT";
    String BROKER_STORAGE_CAPACITY = "BROKER_STORAGE_CAPACITY";
    String BROKER_ADDRESS_FULL_POLICY = "BROKER_ADDRESS_FULL_POLICY";
    String ADMIN_MEMORY_LIMIT = "ADMIN_MEMORY_LIMIT";
    String ROUTER_MEMORY_LIMIT = "ROUTER_MEMORY_LIMIT";
    String ROUTER_LINK_CAPACITY = "ROUTER_LINK_CAPACITY";
    String STANDARD_INFRA_CONFIG_NAME = "STANDARD_INFRA_CONFIG_NAME";
}
