/*
 * Copyright 2017-2018, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

package io.enmasse.controller.standard;

/**
 * Template parameters that are dynamically set by the standard controller.
 */
public interface TemplateParameter {
    String NAME = "NAME";
    String ADDRESS = "ADDRESS";
    String INFRA_UUID = "INFRA_UUID";
    String ADDRESS_SPACE = "ADDRESS_SPACE";
    String CLUSTER_ID = "CLUSTER_ID";

    String AUTHENTICATION_SERVICE_HOST = "AUTHENTICATION_SERVICE_HOST";
    String AUTHENTICATION_SERVICE_PORT = "AUTHENTICATION_SERVICE_PORT";
    String AUTHENTICATION_SERVICE_CA_SECRET = "AUTHENTICATION_SERVICE_CA_SECRET";
    String AUTHENTICATION_SERVICE_CLIENT_SECRET = "AUTHENTICATION_SERVICE_CLIENT_SECRET";
    String AUTHENTICATION_SERVICE_SASL_INIT_HOST = "AUTHENTICATION_SERVICE_SASL_INIT_HOST";
    String REPLICAS = "REPLICAS";

    String BROKER_MEMORY_LIMIT = "BROKER_MEMORY_LIMIT";
    String BROKER_ADDRESS_FULL_POLICY = "BROKER_ADDRESS_FULL_POLICY";
    String BROKER_STORAGE_CAPACITY = "BROKER_STORAGE_CAPACITY";
    String BROKER_GLOBAL_MAX_SIZE = "BROKER_GLOBAL_MAX_SIZE";
    String BROKER_CONNECTOR_NETTY_THREADS = "BROKER_CONNECTOR_NETTY_THREADS";
    String BROKER_CONNECTOR_IDLE_TIMEOUT_MS = "BROKER_CONNECTOR_IDLE_TIMEOUT_MS";

    String BROKER_IMAGE = "BROKER_IMAGE";
    String BROKER_PLUGIN_IMAGE = "BROKER_PLUGIN_IMAGE";
    String TOPIC_FORWARDER_IMAGE = "TOPIC_FORWARDER_IMAGE";
}
