/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta1 "github.com/enmasseproject/enmasse/pkg/apis/user/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeMessagingUsers implements MessagingUserInterface
type FakeMessagingUsers struct {
	Fake *FakeUserV1beta1
	ns   string
}

var messagingusersResource = schema.GroupVersionResource{Group: "user.enmasse.io", Version: "v1beta1", Resource: "messagingusers"}

var messagingusersKind = schema.GroupVersionKind{Group: "user.enmasse.io", Version: "v1beta1", Kind: "MessagingUser"}

// Get takes name of the messagingUser, and returns the corresponding messagingUser object, and an error if there is any.
func (c *FakeMessagingUsers) Get(name string, options v1.GetOptions) (result *v1beta1.MessagingUser, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(messagingusersResource, c.ns, name), &v1beta1.MessagingUser{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.MessagingUser), err
}

// List takes label and field selectors, and returns the list of MessagingUsers that match those selectors.
func (c *FakeMessagingUsers) List(opts v1.ListOptions) (result *v1beta1.MessagingUserList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(messagingusersResource, messagingusersKind, c.ns, opts), &v1beta1.MessagingUserList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.MessagingUserList{ListMeta: obj.(*v1beta1.MessagingUserList).ListMeta}
	for _, item := range obj.(*v1beta1.MessagingUserList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested messagingUsers.
func (c *FakeMessagingUsers) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(messagingusersResource, c.ns, opts))

}

// Create takes the representation of a messagingUser and creates it.  Returns the server's representation of the messagingUser, and an error, if there is any.
func (c *FakeMessagingUsers) Create(messagingUser *v1beta1.MessagingUser) (result *v1beta1.MessagingUser, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(messagingusersResource, c.ns, messagingUser), &v1beta1.MessagingUser{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.MessagingUser), err
}

// Update takes the representation of a messagingUser and updates it. Returns the server's representation of the messagingUser, and an error, if there is any.
func (c *FakeMessagingUsers) Update(messagingUser *v1beta1.MessagingUser) (result *v1beta1.MessagingUser, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(messagingusersResource, c.ns, messagingUser), &v1beta1.MessagingUser{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.MessagingUser), err
}

// Delete takes name of the messagingUser and deletes it. Returns an error if one occurs.
func (c *FakeMessagingUsers) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(messagingusersResource, c.ns, name), &v1beta1.MessagingUser{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeMessagingUsers) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(messagingusersResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1beta1.MessagingUserList{})
	return err
}

// Patch applies the patch and returns the patched messagingUser.
func (c *FakeMessagingUsers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.MessagingUser, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(messagingusersResource, c.ns, name, data, subresources...), &v1beta1.MessagingUser{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.MessagingUser), err
}
