/*
 * Copyright 2018-2019, EnMasse authors.
 * License: Apache License 2.0 (see the file LICENSE or http://apache.org/licenses/LICENSE-2.0.html).
 */

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	clientset "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned"
	adminv1beta1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/admin/v1beta1"
	fakeadminv1beta1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/admin/v1beta1/fake"
	adminv1beta2 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/admin/v1beta2"
	fakeadminv1beta2 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/admin/v1beta2/fake"
	enmassev1beta1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/enmasse/v1beta1"
	fakeenmassev1beta1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/enmasse/v1beta1/fake"
	iotv1alpha1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/iot/v1alpha1"
	fakeiotv1alpha1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/iot/v1alpha1/fake"
	userv1beta1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/user/v1beta1"
	fakeuserv1beta1 "github.com/enmasseproject/enmasse/pkg/client/clientset/versioned/typed/user/v1beta1/fake"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/discovery"
	fakediscovery "k8s.io/client-go/discovery/fake"
	"k8s.io/client-go/testing"
)

// NewSimpleClientset returns a clientset that will respond with the provided objects.
// It's backed by a very simple object tracker that processes creates, updates and deletions as-is,
// without applying any validations and/or defaults. It shouldn't be considered a replacement
// for a real clientset and is mostly useful in simple unit tests.
func NewSimpleClientset(objects ...runtime.Object) *Clientset {
	o := testing.NewObjectTracker(scheme, codecs.UniversalDecoder())
	for _, obj := range objects {
		if err := o.Add(obj); err != nil {
			panic(err)
		}
	}

	cs := &Clientset{}
	cs.discovery = &fakediscovery.FakeDiscovery{Fake: &cs.Fake}
	cs.AddReactor("*", "*", testing.ObjectReaction(o))
	cs.AddWatchReactor("*", func(action testing.Action) (handled bool, ret watch.Interface, err error) {
		gvr := action.GetResource()
		ns := action.GetNamespace()
		watch, err := o.Watch(gvr, ns)
		if err != nil {
			return false, nil, err
		}
		return true, watch, nil
	})

	return cs
}

// Clientset implements clientset.Interface. Meant to be embedded into a
// struct to get a default implementation. This makes faking out just the method
// you want to test easier.
type Clientset struct {
	testing.Fake
	discovery *fakediscovery.FakeDiscovery
}

func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	return c.discovery
}

var _ clientset.Interface = &Clientset{}

// AdminV1beta1 retrieves the AdminV1beta1Client
func (c *Clientset) AdminV1beta1() adminv1beta1.AdminV1beta1Interface {
	return &fakeadminv1beta1.FakeAdminV1beta1{Fake: &c.Fake}
}

// AdminV1beta2 retrieves the AdminV1beta2Client
func (c *Clientset) AdminV1beta2() adminv1beta2.AdminV1beta2Interface {
	return &fakeadminv1beta2.FakeAdminV1beta2{Fake: &c.Fake}
}

// Admin retrieves the AdminV1beta2Client
func (c *Clientset) Admin() adminv1beta2.AdminV1beta2Interface {
	return &fakeadminv1beta2.FakeAdminV1beta2{Fake: &c.Fake}
}

// EnmasseV1beta1 retrieves the EnmasseV1beta1Client
func (c *Clientset) EnmasseV1beta1() enmassev1beta1.EnmasseV1beta1Interface {
	return &fakeenmassev1beta1.FakeEnmasseV1beta1{Fake: &c.Fake}
}

// Enmasse retrieves the EnmasseV1beta1Client
func (c *Clientset) Enmasse() enmassev1beta1.EnmasseV1beta1Interface {
	return &fakeenmassev1beta1.FakeEnmasseV1beta1{Fake: &c.Fake}
}

// IotV1alpha1 retrieves the IotV1alpha1Client
func (c *Clientset) IotV1alpha1() iotv1alpha1.IotV1alpha1Interface {
	return &fakeiotv1alpha1.FakeIotV1alpha1{Fake: &c.Fake}
}

// Iot retrieves the IotV1alpha1Client
func (c *Clientset) Iot() iotv1alpha1.IotV1alpha1Interface {
	return &fakeiotv1alpha1.FakeIotV1alpha1{Fake: &c.Fake}
}

// UserV1beta1 retrieves the UserV1beta1Client
func (c *Clientset) UserV1beta1() userv1beta1.UserV1beta1Interface {
	return &fakeuserv1beta1.FakeUserV1beta1{Fake: &c.Fake}
}

// User retrieves the UserV1beta1Client
func (c *Clientset) User() userv1beta1.UserV1beta1Interface {
	return &fakeuserv1beta1.FakeUserV1beta1{Fake: &c.Fake}
}
