import _pt from "prop-types";

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/OverflowMenu/overflow-menu';
import { OverflowMenuContext } from './OverflowMenuContext';
export const OverflowMenuGroup = (_ref) => {
  let {
    className,
    children,
    isPersistent = false,
    groupType = ''
  } = _ref,
      props = _objectWithoutProperties(_ref, ["className", "children", "isPersistent", "groupType"]);

  return React.createElement(OverflowMenuContext.Consumer, null, value => (isPersistent || !value.isBelowBreakpoint) && React.createElement("div", {
    className: css(styles.overflowMenuGroup, groupType === 'button' && styles.modifiers.buttonGroup, groupType === 'icon' && styles.modifiers.iconButtonGroup, className)
  }, children));
};
OverflowMenuGroup.propTypes = {
  children: _pt.any,
  className: _pt.string,
  isPersistent: _pt.bool,
  groupType: _pt.oneOf(['button', 'icon'])
};
//# sourceMappingURL=OverflowMenuGroup.js.map