import React from 'react';
import { DescriptionProps as PureDescriptionProps } from '@storybook/components';
import { DocsContextProps } from './DocsContext';
import { Component } from './shared';
export declare enum DescriptionType {
    INFO = "info",
    NOTES = "notes",
    DOCGEN = "docgen",
    AUTO = "auto"
}
interface DescriptionProps {
    of?: '.' | Component;
    type?: DescriptionType;
    markdown?: string;
}
export declare const getNotes: (notes?: any) => string;
export declare const getInfo: (info?: any) => string;
export declare const getDocgen: (component?: any) => string;
export declare const getDescriptionProps: ({ of, type, markdown }: DescriptionProps, { parameters }: DocsContextProps) => PureDescriptionProps;
declare const DescriptionContainer: React.FunctionComponent<DescriptionProps>;
export { DescriptionContainer as Description };
