"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.keys");

require("core-js/modules/es.regexp.exec");

require("core-js/modules/es.string.match");

require("core-js/modules/es.string.split");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocsContainer = exports.CodeOrSource = void 0;

var _react = _interopRequireDefault(require("react"));

var _global = require("global");

var _react2 = require("@mdx-js/react");

var _theming = require("@storybook/theming");

var _components = require("@storybook/components");

var _html = require("@storybook/components/html");

var _DocsContext = require("./DocsContext");

var _Anchor = require("./Anchor");

var _Story = require("./Story");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var CodeOrSource = function CodeOrSource(props) {
  var className = props.className,
      children = props.children,
      rest = _objectWithoutProperties(props, ["className", "children"]); // markdown-to-jsx does not add className to inline code


  if (typeof className !== 'string' && (typeof children !== 'string' || !children.match(/[\n\r]/g))) {
    return _react["default"].createElement(_html.Code, null, children);
  } // className: "lang-jsx"


  var language = className && className.split('-');
  return _react["default"].createElement(_components.Source, _extends({
    language: language && language[1] || 'plaintext',
    format: false,
    code: children
  }, rest));
};

exports.CodeOrSource = CodeOrSource;
var defaultComponents = Object.assign({}, _html.components, {
  code: CodeOrSource
});

var DocsContainer = function DocsContainer(_ref) {
  var context = _ref.context,
      children = _ref.children;

  var _ref2 = context || {},
      _ref2$id = _ref2.id,
      storyId = _ref2$id === void 0 ? null : _ref2$id,
      _ref2$parameters = _ref2.parameters,
      parameters = _ref2$parameters === void 0 ? {} : _ref2$parameters;

  var options = parameters.options || {};
  var theme = (0, _theming.ensure)(options.theme);

  var _ref3 = parameters.docs || {},
      _ref3$components = _ref3.components,
      userComponents = _ref3$components === void 0 ? null : _ref3$components;

  var components = Object.assign({}, defaultComponents, {}, userComponents);

  _react["default"].useEffect(function () {
    var element = _global.document.getElementById((0, _Anchor.anchorBlockIdFromId)(storyId));

    if (!element) {
      element = _global.document.getElementById((0, _Story.storyBlockIdFromId)(storyId));
    }

    if (element) {
      var allStories = element.parentElement.querySelectorAll('[id|="anchor-"]');
      var block = 'start';

      if (allStories && allStories[0] === element) {
        block = 'end'; // first story should be shown with the intro content above
      }

      element.scrollIntoView({
        behavior: 'smooth',
        block: block,
        inline: 'nearest'
      });
    }
  }, [storyId]);

  return _react["default"].createElement(_DocsContext.DocsContext.Provider, {
    value: context
  }, _react["default"].createElement(_theming.ThemeProvider, {
    theme: theme
  }, _react["default"].createElement(_react2.MDXProvider, {
    components: components
  }, _react["default"].createElement(_components.DocsWrapper, {
    className: "sbdocs sbdocs-wrapper"
  }, _react["default"].createElement(_components.DocsContent, {
    className: "sbdocs sbdocs-content"
  }, children)))));
};

exports.DocsContainer = DocsContainer;