import React from 'react';
import { PropsTableProps } from '@storybook/components';
export interface SlotContext {
    id?: string;
    selectedKind?: string;
    selectedStory?: string;
    parameters?: any;
    storyStore?: any;
}
export declare type StringSlot = (context: SlotContext) => string | void;
export declare type PropsSlot = (context: SlotContext) => PropsTableProps | void;
export declare type StorySlot = (stories: StoryData[], context: SlotContext) => DocsStoryProps | void;
export declare type StoriesSlot = (stories: StoryData[], context: SlotContext) => DocsStoryProps[] | void;
export interface DocsPageProps {
    titleSlot: StringSlot;
    subtitleSlot: StringSlot;
    descriptionSlot: StringSlot;
    primarySlot: StorySlot;
    propsSlot: PropsSlot;
    storiesSlot: StoriesSlot;
}
interface DocsStoryProps {
    id: string;
    name: string;
    expanded?: boolean;
    withToolbar?: boolean;
    parameters?: any;
}
interface StoryData {
    id: string;
    kind: string;
    name: string;
    parameters?: any;
}
export declare const DocsPage: React.FunctionComponent<DocsPageProps>;
export {};
