import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { KnobControlConfig, KnobControlProps } from './types';
declare type CheckboxesTypeKnobValue = string[];
export interface CheckboxesTypeKnob extends KnobControlConfig<CheckboxesTypeKnobValue> {
    options: Record<string, string>;
}
interface CheckboxesTypeProps extends KnobControlProps<CheckboxesTypeKnobValue>, CheckboxesWrapperProps {
    knob: CheckboxesTypeKnob;
}
interface CheckboxesTypeState {
    values: CheckboxesTypeKnobValue;
}
interface CheckboxesWrapperProps {
    isInline: boolean;
}
export default class CheckboxesType extends Component<CheckboxesTypeProps, CheckboxesTypeState> {
    static defaultProps: CheckboxesTypeProps;
    static propTypes: {
        knob: PropTypes.Validator<CheckboxesTypeKnob>;
        onChange: PropTypes.Validator<(value: string[]) => string[]>;
        isInline: PropTypes.Validator<boolean>;
    };
    static serialize: (value: string[]) => string[];
    static deserialize: (value: string[]) => string[];
    constructor(props: CheckboxesTypeProps);
    handleChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
    renderCheckboxList: ({ options }: CheckboxesTypeKnob) => JSX.Element[];
    renderCheckbox: (label: string, value: string) => JSX.Element;
    render(): JSX.Element;
}
export {};
