import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { KnobControlConfig, KnobControlProps } from './types';
declare type NumberTypeKnobValue = number;
export interface NumberTypeKnobOptions {
    range?: boolean;
    min?: number;
    max?: number;
    step?: number;
}
export interface NumberTypeKnob extends KnobControlConfig<NumberTypeKnobValue>, NumberTypeKnobOptions {
    value: NumberTypeKnobValue;
}
interface NumberTypeProps extends KnobControlProps<NumberTypeKnobValue | null> {
    knob: NumberTypeKnob;
}
export default class NumberType extends Component<NumberTypeProps> {
    static propTypes: {
        knob: PropTypes.Validator<NumberTypeKnob>;
        onChange: PropTypes.Validator<(value: number | null) => number | null>;
    };
    static defaultProps: NumberTypeProps;
    static serialize: (value: number | null | undefined) => string;
    static deserialize: (value: string) => number | null;
    shouldComponentUpdate(nextProps: NumberTypeProps): boolean;
    handleChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
    render(): JSX.Element;
}
export {};
