/// <reference types="node" />
/// <reference types="webpack-env" />
import { StoryFn, Parameters, OptionsParameter } from '@storybook/addons';
import { ClientApiParams, DecoratorFunction, StoryApi } from './types';
import StoryStore from './story_store';
export declare const defaultDecorateStory: (storyFn: StoryFn<unknown>, decorators: DecoratorFunction<unknown>[]) => StoryFn<unknown>;
export default class ClientApi {
    private _storyStore;
    private _addons;
    private _globalDecorators;
    private _globalParameters;
    private _decorateStory;
    constructor({ storyStore, decorateStory }: ClientApiParams);
    setAddon: (addon: any) => void;
    getSeparators: () => {
        hierarchyRootSeparator: string;
        hierarchySeparator: RegExp;
    } & OptionsParameter;
    addDecorator: (decorator: DecoratorFunction<unknown>) => void;
    addParameters: (parameters: Parameters | {
        globalParameter: "string";
    }) => void;
    clearDecorators: () => void;
    storiesOf: <StoryFnReturnType = unknown>(kind: string, m: NodeModule) => StoryApi<StoryFnReturnType>;
    getStorybook: () => {
        kind: string;
        fileName: string;
        stories: {
            name: any;
            render: any;
        }[];
    }[];
    raw: () => import("./types").StoreItem[];
    store: () => StoryStore;
}
