"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.keys");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Source = exports.SourceError = void 0;

var _react = _interopRequireDefault(require("react"));

var _theming = require("@storybook/theming");

var _EmptyBlock = require("./EmptyBlock");

var _syntaxhighlighter = require("../syntaxhighlighter/syntaxhighlighter");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var StyledSyntaxHighlighter = (0, _theming.styled)(_syntaxhighlighter.SyntaxHighlighter)(function (_ref) {
  var theme = _ref.theme;
  return {
    // DocBlocks-specific styling and overrides
    fontSize: "".concat(theme.typography.size.s2 - 1, "px"),
    lineHeight: '19px',
    margin: '25px 0 40px',
    borderRadius: theme.appBorderRadius,
    boxShadow: theme.base === 'light' ? 'rgba(0, 0, 0, 0.10) 0 1px 3px 0' : 'rgba(0, 0, 0, 0.20) 0 2px 5px 0',
    'pre.hljs': {
      padding: 20,
      background: 'inherit'
    }
  };
});
var SourceError;
exports.SourceError = SourceError;

(function (SourceError) {
  SourceError["NO_STORY"] = "There\u2019s no story here.";
  SourceError["SOURCE_UNAVAILABLE"] = "Oh no! The source is not available.";
})(SourceError || (exports.SourceError = SourceError = {}));

/**
 * Syntax-highlighted source code for a component (or anything!)
 */
var Source = function Source(props) {
  var _ref2 = props,
      error = _ref2.error;

  if (error) {
    return _react["default"].createElement(_EmptyBlock.EmptyBlock, props, error);
  }

  var _ref3 = props,
      language = _ref3.language,
      code = _ref3.code,
      dark = _ref3.dark,
      format = _ref3.format,
      rest = _objectWithoutProperties(_ref3, ["language", "code", "dark", "format"]);

  var syntaxHighlighter = _react["default"].createElement(StyledSyntaxHighlighter, _extends({
    bordered: true,
    copyable: true,
    format: format,
    language: language,
    className: "docblock-source"
  }, rest), code);

  if (typeof dark === 'undefined') {
    return syntaxHighlighter;
  }

  var overrideTheme = dark ? _theming.themes.dark : _theming.themes.light;
  return _react["default"].createElement(_theming.ThemeProvider, {
    theme: (0, _theming.convert)(overrideTheme)
  }, syntaxHighlighter);
};

exports.Source = Source;
Source.displayName = "Source";