import _extends from "@babel/runtime/helpers/extends";
import _inheritsLoose from "@babel/runtime/helpers/inheritsLoose";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { constants } from 'focus-lock';
import FocusTrap, { onBlur, onFocus } from './Trap';
import { hiddenGuard } from './FocusGuard';

var RenderChildren = function RenderChildren(_ref) {
  var children = _ref.children;
  return React.createElement("div", null, children);
};

RenderChildren.propTypes = process.env.NODE_ENV !== "production" ? {
  children: PropTypes.node.isRequired
} : {};
var Fragment = React.Fragment ? React.Fragment : RenderChildren;
var emptyArray = [];

var FocusLock =
/*#__PURE__*/
function (_Component) {
  _inheritsLoose(FocusLock, _Component);

  function FocusLock() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _Component.call.apply(_Component, [this].concat(args)) || this;

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "state", {
      observed: undefined
    });

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "onActivation", function () {
      _this.originalFocusedElement = _this.originalFocusedElement || document && document.activeElement;

      if (_this.state.observed && _this.props.onActivation) {
        _this.props.onActivation(_this.state.observed);
      }

      _this.isActive = true;
    });

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "onDeactivation", function () {
      _this.isActive = false;

      if (_this.props.returnFocus && _this.originalFocusedElement && _this.originalFocusedElement.focus) {
        _this.originalFocusedElement.focus();

        _this.originalFocusedElement = null;
      }

      if (_this.props.onDeactivation) {
        _this.props.onDeactivation(_this.state.observed);
      }
    });

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "onFocus", function (event) {
      if (_this.isActive) {
        onFocus(event);
      }
    });

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "onBlur", onBlur);

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "setObserveNode", function (observed) {
      if (_this.state.observed !== observed) {
        _this.setState({
          observed: observed
        });
      }
    });

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "isActive", false);

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "originalFocusedElement", null);

    return _this;
  }

  var _proto = FocusLock.prototype;

  _proto.render = function render() {
    var _extends2;

    var _this$props = this.props,
        children = _this$props.children,
        disabled = _this$props.disabled,
        noFocusGuards = _this$props.noFocusGuards,
        persistentFocus = _this$props.persistentFocus,
        autoFocus = _this$props.autoFocus,
        allowTextSelection = _this$props.allowTextSelection,
        group = _this$props.group,
        className = _this$props.className,
        whiteList = _this$props.whiteList,
        _this$props$shards = _this$props.shards,
        shards = _this$props$shards === void 0 ? emptyArray : _this$props$shards,
        _this$props$as = _this$props.as,
        Container = _this$props$as === void 0 ? 'div' : _this$props$as,
        _this$props$lockProps = _this$props.lockProps,
        containerProps = _this$props$lockProps === void 0 ? {} : _this$props$lockProps;
    var observed = this.state.observed;

    if (process.env.NODE_ENV !== 'production') {
      if (typeof allowTextSelection !== 'undefined') {
        // eslint-disable-next-line no-console
        console.warn('React-Focus-Lock: allowTextSelection is deprecated and enabled by default');
      }
    }

    var lockProps = _extends((_extends2 = {}, _extends2[constants.FOCUS_DISABLED] = disabled && 'disabled', _extends2[constants.FOCUS_GROUP] = group, _extends2), containerProps);

    var hasLeadingGuards = noFocusGuards !== true;
    var hasTailingGuards = hasLeadingGuards && noFocusGuards !== 'tail';
    return React.createElement(Fragment, null, hasLeadingGuards && [React.createElement("div", {
      key: "guard-first",
      "data-focus-guard": true,
      tabIndex: disabled ? -1 : 0,
      style: hiddenGuard
    }), // nearest focus guard
    React.createElement("div", {
      key: "guard-nearest",
      "data-focus-guard": true,
      tabIndex: disabled ? -1 : 1,
      style: hiddenGuard
    })], React.createElement(Container, _extends({
      ref: this.setObserveNode
    }, lockProps, {
      className: className,
      onBlur: this.onBlur,
      onFocus: this.onFocus
    }), React.createElement(FocusTrap, {
      observed: observed,
      disabled: disabled,
      persistentFocus: persistentFocus,
      autoFocus: autoFocus,
      whiteList: whiteList,
      shards: shards,
      onActivation: this.onActivation,
      onDeactivation: this.onDeactivation
    }), children), hasTailingGuards && React.createElement("div", {
      "data-focus-guard": true,
      tabIndex: disabled ? -1 : 0,
      style: hiddenGuard
    }));
  };

  return FocusLock;
}(Component);

FocusLock.propTypes = process.env.NODE_ENV !== "production" ? {
  children: PropTypes.node.isRequired,
  disabled: PropTypes.bool,
  returnFocus: PropTypes.bool,
  noFocusGuards: PropTypes.bool,
  allowTextSelection: PropTypes.bool,
  autoFocus: PropTypes.bool,
  persistentFocus: PropTypes.bool,
  group: PropTypes.string,
  className: PropTypes.string,
  whiteList: PropTypes.func,
  shards: PropTypes.arrayOf(PropTypes.any),
  as: PropTypes.oneOfType([PropTypes.string, PropTypes.func, PropTypes.object]),
  lockProps: PropTypes.object,
  onActivation: PropTypes.func,
  onDeactivation: PropTypes.func
} : {};
FocusLock.defaultProps = {
  disabled: false,
  returnFocus: false,
  noFocusGuards: false,
  autoFocus: true,
  persistentFocus: false,
  allowTextSelection: undefined,
  group: undefined,
  className: undefined,
  whiteList: undefined,
  shards: undefined,
  as: 'div',
  lockProps: {},
  onActivation: undefined,
  onDeactivation: undefined
};
export default FocusLock;