"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.concat");

require("core-js/modules/es.array.filter");

require("core-js/modules/es.array.find");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.from");

require("core-js/modules/es.array.includes");

require("core-js/modules/es.array.index-of");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.map");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.function.name");

require("core-js/modules/es.map");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.keys");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.promise");

require("core-js/modules/es.regexp.exec");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.set");

require("core-js/modules/es.string.includes");

require("core-js/modules/es.string.iterator");

require("core-js/modules/es.string.match");

require("core-js/modules/web.dom-collections.for-each");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isExportStory = isExportStory;
exports["default"] = start;
exports.getContext = void 0;

require("regenerator-runtime/runtime");

var _global = require("global");

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _utilDeprecate = _interopRequireDefault(require("util-deprecate"));

var _ansiToHtml = _interopRequireDefault(require("ansi-to-html"));

var _addons = _interopRequireDefault(require("@storybook/addons"));

var _channelPostmessage = _interopRequireDefault(require("@storybook/channel-postmessage"));

var _clientApi2 = require("@storybook/client-api");

var _utils = require("@storybook/router/utils");

var _clientLogger = require("@storybook/client-logger");

var _coreEvents = _interopRequireDefault(require("@storybook/core-events"));

var _url = require("./url");

var _NoDocs = require("./NoDocs");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var ansiConverter = new _ansiToHtml["default"]();
var classes = {
  MAIN: 'sb-show-main',
  NOPREVIEW: 'sb-show-nopreview',
  ERROR: 'sb-show-errordisplay'
};

function matches(storyKey, arrayOrRegex) {
  if (Array.isArray(arrayOrRegex)) {
    return arrayOrRegex.includes(storyKey);
  }

  return storyKey.match(arrayOrRegex);
}

function isExportStory(key, _ref) {
  var includeStories = _ref.includeStories,
      excludeStories = _ref.excludeStories;
  return (// https://babeljs.io/docs/en/babel-plugin-transform-modules-commonjs
    key !== '__esModule' && (!includeStories || matches(key, includeStories)) && (!excludeStories || !matches(key, excludeStories))
  );
}

function showMain() {
  _global.document.body.classList.remove(classes.NOPREVIEW);

  _global.document.body.classList.remove(classes.ERROR);

  _global.document.body.classList.add(classes.MAIN);
}

function showNopreview() {
  _global.document.body.classList.remove(classes.MAIN);

  _global.document.body.classList.remove(classes.ERROR);

  _global.document.body.classList.add(classes.NOPREVIEW);
}

function showErrorDisplay(_ref2) {
  var _ref2$message = _ref2.message,
      message = _ref2$message === void 0 ? '' : _ref2$message,
      _ref2$stack = _ref2.stack,
      stack = _ref2$stack === void 0 ? '' : _ref2$stack;
  _global.document.getElementById('error-message').innerHTML = ansiConverter.toHtml(message);
  _global.document.getElementById('error-stack').innerHTML = ansiConverter.toHtml(stack);

  _global.document.body.classList.remove(classes.MAIN);

  _global.document.body.classList.remove(classes.NOPREVIEW);

  _global.document.body.classList.add(classes.ERROR);
} // showError is used by the various app layers to inform the user they have done something
// wrong -- for instance returned the wrong thing from a story


function showError(_ref3) {
  var title = _ref3.title,
      description = _ref3.description;

  _addons["default"].getChannel().emit(_coreEvents["default"].STORY_ERRORED, {
    title: title,
    description: description
  });

  showErrorDisplay({
    message: title,
    stack: description
  });
} // showException is used if we fail to render the story and it is uncaught by the app layer


function showException(exception) {
  _addons["default"].getChannel().emit(_coreEvents["default"].STORY_THREW_EXCEPTION, exception);

  showErrorDisplay(exception); // Log the stack to the console. So, user could check the source code.

  _clientLogger.logger.error(exception);
}

var isBrowser = _global.navigator && _global.navigator.userAgent && _global.navigator.userAgent !== 'storyshots' && !(_global.navigator.userAgent.indexOf('Node.js') > -1) && !(_global.navigator.userAgent.indexOf('jsdom') > -1);

var getContext = function () {
  var cache;
  return function (decorateStory) {
    if (cache) {
      return cache;
    }

    var channel = null;

    if (isBrowser) {
      try {
        channel = _addons["default"].getChannel();
      } catch (e) {
        channel = (0, _channelPostmessage["default"])({
          page: 'preview'
        });

        _addons["default"].setChannel(channel);
      }
    }

    var storyStore;
    var clientApi;

    if (typeof _global.window !== 'undefined' && _global.window.__STORYBOOK_CLIENT_API__) {
      clientApi = _global.window.__STORYBOOK_CLIENT_API__; // eslint-disable-next-line no-underscore-dangle

      storyStore = clientApi._storyStore;
    } else {
      storyStore = new _clientApi2.StoryStore({
        channel: channel
      });
      clientApi = new _clientApi2.ClientApi({
        storyStore: storyStore,
        decorateStory: decorateStory
      });
    }

    var _clientApi = clientApi,
        clearDecorators = _clientApi.clearDecorators;
    var configApi = new _clientApi2.ConfigApi({
      clearDecorators: clearDecorators,
      storyStore: storyStore,
      channel: channel,
      clientApi: clientApi
    });
    return {
      configApi: configApi,
      storyStore: storyStore,
      channel: channel,
      clientApi: clientApi,
      showMain: showMain,
      showError: showError,
      showException: showException
    };
  };
}();

exports.getContext = getContext;

function focusInInput(event) {
  return /input|textarea/i.test(event.target.tagName) || event.target.getAttribute('contenteditable') !== null;
}

function start(render) {
  var _ref4 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      decorateStory = _ref4.decorateStory;

  var context = getContext(decorateStory);
  var clientApi = context.clientApi,
      channel = context.channel,
      configApi = context.configApi,
      storyStore = context.storyStore; // Provide access to external scripts if `window` is defined.
  // NOTE this is different to isBrowser, primarily for the JSDOM use case

  var previousKind = '';
  var previousStory = '';
  var previousRevision = -1;
  var previousViewMode = '';
  var previousId = null;

  var renderMain = function renderMain(forceRender) {
    var revision = storyStore.getRevision();
    var loadError = storyStore.getError();

    var _storyStore$getSelect = storyStore.getSelection(),
        storyId = _storyStore$getSelect.storyId,
        urlViewMode = _storyStore$getSelect.viewMode;

    var data = storyStore.fromId(storyId);

    var _ref5 = data || {},
        kind = _ref5.kind,
        name = _ref5.name,
        getDecorated = _ref5.getDecorated,
        id = _ref5.id,
        parameters = _ref5.parameters,
        error = _ref5.error;

    var viewMode = parameters && parameters.docsOnly ? 'docs' : urlViewMode;
    var renderContext = Object.assign({}, context, {}, data, {
      selectedKind: kind,
      selectedStory: name,
      parameters: parameters,
      forceRender: forceRender
    });

    if (loadError || error) {
      showErrorDisplay(loadError || error);
      return;
    } // Render story only if selectedKind or selectedStory have changed.
    // However, we DO want the story to re-render if the store itself has changed
    // (which happens at the moment when HMR occurs)


    if (!forceRender && revision === previousRevision && viewMode === previousViewMode && kind === previousKind && name === previousStory) {
      _addons["default"].getChannel().emit(_coreEvents["default"].STORY_UNCHANGED, {
        id: id,
        revision: revision,
        kind: kind,
        name: name,
        viewMode: viewMode
      });

      return;
    }

    if (!forceRender && previousKind && previousStory) {
      _addons["default"].getChannel().emit(_coreEvents["default"].STORY_CHANGED, id);
    }

    switch (previousViewMode) {
      case 'docs':
        if (previousKind != null && (kind !== previousKind || viewMode !== previousViewMode)) {
          storyStore.cleanHooksForKind(previousKind);

          _reactDom["default"].unmountComponentAtNode(_global.document.getElementById('docs-root'));
        }

        break;

      case 'story':
      default:
        if (previousId != null && (id !== previousId || viewMode !== previousViewMode)) {
          storyStore.cleanHooks(previousId);

          _reactDom["default"].unmountComponentAtNode(_global.document.getElementById('root'));
        }

    } // Docs view renders into a different root ID to avoid conflicts
    // with the user's view layer. Therefore we need to clean up whenever
    // we transition between view modes


    if (viewMode !== previousViewMode) {
      switch (viewMode) {
        case 'docs':
          {
            showMain();

            _global.document.getElementById('root').setAttribute('hidden', true);

            _global.document.getElementById('docs-root').removeAttribute('hidden');

            break;
          }

        case 'story':
        default:
          {
            if (previousViewMode === 'docs') {
              _global.document.getElementById('docs-root').setAttribute('hidden', true);

              _global.document.getElementById('root').removeAttribute('hidden');
            }
          }
      }
    } // Given a cleaned up state, render the appropriate view mode


    switch (viewMode) {
      case 'docs':
        {
          var docs = parameters && parameters.docs || {}; // eslint-disable-next-line react/prop-types

          var DocsContainer = docs.container || function (_ref6) {
            var children = _ref6.children;
            return _react["default"].createElement(_react["default"].Fragment, null, children);
          };

          var Page = docs.page || _NoDocs.NoDocs;

          _reactDom["default"].render(_react["default"].createElement(DocsContainer, {
            context: renderContext
          }, _react["default"].createElement(Page, null)), _global.document.getElementById('docs-root'), function () {
            return _addons["default"].getChannel().emit(_coreEvents["default"].DOCS_RENDERED, kind);
          });

          break;
        }

      case 'story':
      default:
        {
          if (getDecorated) {
            _asyncToGenerator(
            /*#__PURE__*/
            regeneratorRuntime.mark(function _callee() {
              return regeneratorRuntime.wrap(function _callee$(_context) {
                while (1) {
                  switch (_context.prev = _context.next) {
                    case 0:
                      _context.prev = 0;
                      _context.next = 3;
                      return render(renderContext);

                    case 3:
                      _addons["default"].getChannel().emit(_coreEvents["default"].STORY_RENDERED, id);

                      _context.next = 9;
                      break;

                    case 6:
                      _context.prev = 6;
                      _context.t0 = _context["catch"](0);
                      showException(_context.t0);

                    case 9:
                    case "end":
                      return _context.stop();
                  }
                }
              }, _callee, null, [[0, 6]]);
            }))();
          } else {
            showNopreview();

            _addons["default"].getChannel().emit(_coreEvents["default"].STORY_MISSING, id);
          }

          break;
        }
    }

    previousRevision = revision;
    previousKind = kind;
    previousStory = name;
    previousViewMode = viewMode;
    previousId = id;

    if (!forceRender && viewMode !== 'docs') {
      _global.document.documentElement.scrollTop = 0;
    }
  }; // initialize the UI


  var renderUI = function renderUI(forceRender) {
    if (isBrowser) {
      try {
        renderMain(forceRender);
      } catch (ex) {
        showException(ex);
      }
    }
  };

  var forceReRender = function forceReRender() {
    return renderUI(true);
  }; // channel can be null in NodeJS


  if (isBrowser) {
    var deprecatedToId = (0, _utilDeprecate["default"])(_utils.toId, "Passing name+kind to the SET_CURRENT_STORY event is deprecated, use a storyId instead");
    channel.on(_coreEvents["default"].FORCE_RE_RENDER, forceReRender);
    channel.on(_coreEvents["default"].SET_CURRENT_STORY, function (_ref8) {
      var inputStoryId = _ref8.storyId,
          name = _ref8.name,
          kind = _ref8.kind,
          viewMode = _ref8.viewMode;
      var storyId = inputStoryId; // For backwards compatibility

      if (!storyId) {
        if (!name || !kind) {
          throw new Error('You should pass `storyId` into SET_CURRENT_STORY');
        }

        storyId = deprecatedToId(kind, name);
      }

      storyStore.setSelection({
        storyId: storyId,
        viewMode: viewMode
      });
      (0, _url.setPath)({
        storyId: storyId,
        viewMode: viewMode
      });
    }); // Handle keyboard shortcuts

    _global.window.onkeydown = function (event) {
      if (!focusInInput(event)) {
        // We have to pick off the keys of the event that we need on the other side
        var altKey = event.altKey,
            ctrlKey = event.ctrlKey,
            metaKey = event.metaKey,
            shiftKey = event.shiftKey,
            key = event.key,
            code = event.code,
            keyCode = event.keyCode;
        channel.emit(_coreEvents["default"].PREVIEW_KEYDOWN, {
          event: {
            altKey: altKey,
            ctrlKey: ctrlKey,
            metaKey: metaKey,
            shiftKey: shiftKey,
            key: key,
            code: code,
            keyCode: keyCode
          }
        });
      }
    };
  }

  storyStore.on(_coreEvents["default"].STORY_INIT, function () {
    var _initializePath = (0, _url.initializePath)(),
        storyId = _initializePath.storyId,
        viewMode = _initializePath.viewMode;

    storyStore.setSelection({
      storyId: storyId,
      viewMode: viewMode
    });
  });
  storyStore.on(_coreEvents["default"].STORY_RENDER, renderUI);

  if (typeof _global.window !== 'undefined') {
    _global.window.__STORYBOOK_CLIENT_API__ = clientApi;
    _global.window.__STORYBOOK_STORY_STORE__ = storyStore;
    _global.window.__STORYBOOK_ADDONS_CHANNEL__ = channel; // may not be defined
  }

  var previousExports = new Map();

  var loadStories = function loadStories(loadable, framework) {
    return function () {
      // Make sure we don't try to define a kind more than once within the same load
      var loadedKinds = new Set();
      var reqs = null;

      if (Array.isArray(loadable)) {
        reqs = loadable;
      } else if (loadable.keys) {
        reqs = [loadable];
      }

      var currentExports = new Map();

      if (reqs) {
        reqs.forEach(function (req) {
          req.keys().forEach(function (filename) {
            var fileExports = req(filename);
            currentExports.set(fileExports, typeof req.resolve === 'function' ? req.resolve(filename) : null);
          });
        });
      } else {
        var exported = loadable();

        if (Array.isArray(exported) && !exported.find(function (obj) {
          return !obj["default"];
        })) {
          currentExports = new Map(exported.map(function (fileExports) {
            return [fileExports, null];
          }));
        } else if (exported) {
          _clientLogger.logger.warn("Loader function passed to 'configure' should return void or an array of module exports that all contain a 'default' export. Received: ".concat(JSON.stringify(exported)));
        }
      }

      var removed = _toConsumableArray(previousExports.keys()).filter(function (exp) {
        return !currentExports.has(exp);
      });

      removed.forEach(function (exp) {
        if (exp["default"]) {
          storyStore.removeStoryKind(exp["default"].title);
        }
      });

      if (removed.length > 0) {
        storyStore.incrementRevision();
      }

      var added = _toConsumableArray(currentExports.keys()).filter(function (exp) {
        return !previousExports.has(exp);
      });

      added.forEach(function (fileExports) {
        // An old-style story file
        if (!fileExports["default"]) {
          return;
        }

        if (!fileExports["default"].title) {
          throw new Error("Unexpected default export without title: ".concat(JSON.stringify(fileExports["default"])));
        }

        var meta = fileExports["default"],
            exports = _objectWithoutProperties(fileExports, ["default"]);

        var kindName = meta.title,
            params = meta.parameters,
            decos = meta.decorators,
            component = meta.component;

        if (loadedKinds.has(kindName)) {
          throw new Error("Duplicate title '".concat(kindName, "' used in multiple files; use unique titles or combine '").concat(kindName, "' stories into a single file."));
        }

        loadedKinds.add(kindName); // We pass true here to avoid the warning about HMR. It's cool clientApi, we got this

        var kind = clientApi.storiesOf(kindName, true); // we should always have a framework, rest optional

        kind.addParameters(Object.assign({
          framework: framework,
          component: component,
          fileName: currentExports.get(fileExports)
        }, params));
        (decos || []).forEach(function (decorator) {
          kind.addDecorator(decorator);
        });
        Object.keys(exports).forEach(function (key) {
          if (isExportStory(key, meta)) {
            var storyFn = exports[key];

            var _ref9 = storyFn.story || {},
                name = _ref9.name,
                parameters = _ref9.parameters,
                decorators = _ref9.decorators;

            if (parameters && parameters.decorators) {
              (0, _utilDeprecate["default"])(function () {}, "".concat(kindName, " => ").concat(name || key, ": story.parameters.decorators is deprecated; use story.decorators instead."))();
            }

            var decoratorParams = decorators ? {
              decorators: decorators
            } : null;
            var displayNameParams = name ? {
              displayName: name
            } : {};
            kind.add((0, _utils.storyNameFromExport)(key), storyFn, Object.assign({}, parameters, {}, decoratorParams, {}, displayNameParams));
          }
        });
      });
      previousExports = currentExports;
    };
  };

  var loaded = false;
  /**
   * Load a collection of stories. If it has a default export, assume that it is a module-style
   * file and process its named exports as stories. If not, assume it's an old-style
   * storiesof file and simply require it.
   *
   * @param {*} loadable a require.context `req`, an array of `req`s, or a loader function that returns void or an array of exports
   * @param {*} m - ES module object for hot-module-reloading (HMR)
   * @param {*} framework - name of framework in use, e.g. "react"
   */

  var configure = function configure(loadable, m, framework) {
    if (m && m.hot && m.hot.dispose) {
      var _ref10 = m.hot.data || {};

      var _ref10$previousExport = _ref10.previousExports;
      previousExports = _ref10$previousExport === void 0 ? new Map() : _ref10$previousExport;
      m.hot.dispose(function (data) {
        loaded = false; // eslint-disable-next-line no-param-reassign

        data.previousExports = previousExports;
      });
    }

    if (loaded) {
      _clientLogger.logger.warn('Unexpected loaded state. Did you call `load` twice?');
    }

    loaded = true;
    configApi.configure(loadStories(loadable, framework), m);
  };

  return {
    configure: configure,
    context: context,
    clientApi: clientApi,
    configApi: configApi,
    forceReRender: forceReRender
  };
}