"use strict";

require("core-js/modules/es.object.define-property");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSource = addSource;
exports.withSource = withSource;

var _addons = _interopRequireDefault(require("@storybook/addons"));

var _events = require("./events");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var getLocation = function getLocation(context, locationsMap) {
  return locationsMap[context.id];
};

function sendEvent(context, source, locationsMap, mainFileLocation, dependencies, localDependencies, prefix, idsToFrameworks) {
  var channel = _addons["default"].getChannel();

  var currentLocation = getLocation(context, locationsMap);
  channel.emit(_events.STORY_EVENT_ID, {
    edition: {
      source: source,
      mainFileLocation: mainFileLocation,
      dependencies: dependencies,
      localDependencies: localDependencies,
      prefix: prefix,
      idsToFrameworks: idsToFrameworks
    },
    story: {
      kind: context.kind,
      story: context.story
    },
    location: {
      currentLocation: currentLocation,
      locationsMap: locationsMap
    }
  });
}

function addSource(storyFn, sourceContext) {
  var source = sourceContext.__STORY__,
      _sourceContext$__ADDS = sourceContext.__ADDS_MAP__,
      locationsMap = _sourceContext$__ADDS === void 0 ? {} : _sourceContext$__ADDS,
      _sourceContext$__MAIN = sourceContext.__MAIN_FILE_LOCATION__,
      mainFileLocation = _sourceContext$__MAIN === void 0 ? '/index.js' : _sourceContext$__MAIN,
      _sourceContext$__MODU = sourceContext.__MODULE_DEPENDENCIES__,
      dependencies = _sourceContext$__MODU === void 0 ? [] : _sourceContext$__MODU,
      _sourceContext$__LOCA = sourceContext.__LOCAL_DEPENDENCIES__,
      localDependencies = _sourceContext$__LOCA === void 0 ? {} : _sourceContext$__LOCA,
      prefix = sourceContext.__SOURCE_PREFIX__,
      idsToFrameworks = sourceContext.__IDS_TO_FRAMEWORKS__;

  var decorated = function decorated() {
    var context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    sendEvent(context, source, locationsMap, mainFileLocation, dependencies, localDependencies, prefix, idsToFrameworks);

    if (typeof storyFn === 'function') {
      return storyFn(context);
    }

    return storyFn;
  };

  decorated.story = (storyFn || {}).story;
  return decorated;
}

function withSource(source) {
  var locationsMap = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var mainFileLocation = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '/index.js';
  var dependencies = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
  var localDependencies = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};
  var prefix = arguments.length > 5 ? arguments[5] : undefined;
  var idsToFrameworks = arguments.length > 6 ? arguments[6] : undefined;
  return function (storyFn, context) {
    sendEvent(context, source, locationsMap, mainFileLocation, dependencies, localDependencies, prefix, idsToFrameworks);
    return storyFn(context);
  };
}