"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isUndefined = _interopRequireDefault(require("../../utils/isUndefined"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Returns whether the specified component's focus tree ID indicates it is a focus-only
 * HotKeys component, or not
 * @param {FocusTreeId} focusTreeId The focus tree id for the component
 * @returns {Boolean} Whether the HotKeys component is focus-only
 */
function isFromFocusOnlyComponent(focusTreeId) {
  return !(0, _isUndefined.default)(focusTreeId);
}

var _default = isFromFocusOnlyComponent;
exports.default = _default;