"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _hasKey = _interopRequireDefault(require("./object/hasKey"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function invertArrayDictionary(dictionary) {
  return Object.keys(dictionary).reduce(function (memo, unshiftedKey) {
    var arrayValue = dictionary[unshiftedKey];
    arrayValue.forEach(function (shiftedKey) {
      if (!(0, _hasKey.default)(memo, shiftedKey)) {
        memo[shiftedKey] = [];
      }

      memo[shiftedKey].push(unshiftedKey);
    });
    return memo;
  }, {});
}

var _default = invertArrayDictionary;
exports.default = _default;