import hasKey from './object/hasKey';

function invertArrayDictionary(dictionary) {
  return Object.keys(dictionary).reduce(function (memo, unshiftedKey) {
    var arrayValue = dictionary[unshiftedKey];
    arrayValue.forEach(function (shiftedKey) {
      if (!hasKey(memo, shiftedKey)) {
        memo[shiftedKey] = [];
      }

      memo[shiftedKey].push(unshiftedKey);
    });
    return memo;
  }, {});
}

export default invertArrayDictionary;