"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.concat");

require("core-js/modules/es.array.find");

require("core-js/modules/es.array.for-each");

require("core-js/modules/es.array.is-array");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.join");

require("core-js/modules/es.array.reduce");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.assign");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.entries");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.regexp.exec");

require("core-js/modules/es.string.iterator");

require("core-js/modules/es.string.starts-with");

require("core-js/modules/es.string.trim");

require("core-js/modules/web.dom-collections.for-each");

require("core-js/modules/web.dom-collections.iterator");

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var mdxToJsx = require('@mdx-js/mdx/mdx-hast-to-jsx');

var parser = require('@babel/parser');

var generate = require('@babel/generator')["default"];

var camelCase = require('lodash/camelCase');

var jsStringEscape = require('js-string-escape');

var _require = require('@storybook/router/utils'),
    toId = _require.toId,
    storyNameFromExport = _require.storyNameFromExport; // Generate the MDX as is, but append named exports for every
// story in the contents


var STORY_REGEX = /^<Story[\s>]/;
var PREVIEW_REGEX = /^<Preview[\s>]/;
var META_REGEX = /^<Meta[\s>]/;
var RESERVED = /^(?:do|if|in|for|let|new|try|var|case|else|enum|eval|false|null|this|true|void|with|await|break|catch|class|const|super|throw|while|yield|delete|export|import|public|return|static|switch|typeof|default|extends|finally|package|private|continue|debugger|function|arguments|interface|protected|implements|instanceof)$/;

function getAttr(elt, what) {
  var attr = elt.attributes.find(function (n) {
    return n.name.name === what;
  });
  return attr && attr.value;
}

var isReserved = function isReserved(name) {
  return RESERVED.exec(name);
};

var startsWithNumber = function startsWithNumber(name) {
  return /^\d/.exec(name);
};

var sanitizeName = function sanitizeName(name) {
  var key = camelCase(name);

  if (startsWithNumber(key)) {
    key = "_".concat(key);
  } else if (isReserved(key)) {
    key = "".concat(key, "Story");
  }

  return key;
};

var getStoryKey = function getStoryKey(name, counter) {
  return name ? sanitizeName(name) : "story".concat(counter);
};

function genStoryExport(ast, context) {
  var storyName = getAttr(ast.openingElement, 'name');
  var storyId = getAttr(ast.openingElement, 'id');
  storyName = storyName && storyName.value;
  storyId = storyId && storyId.value;

  if (!storyId && !storyName) {
    throw new Error('Expected a story name or ID attribute');
  } // We don't generate exports for story references or the smart "current story"


  if (storyId || !storyName) {
    return null;
  } // console.log('genStoryExport', JSON.stringify(ast, null, 2));


  var statements = [];
  var storyKey = getStoryKey(storyName, context.counter);
  var body = ast.children.find(function (n) {
    return n.type !== 'JSXText';
  });
  var storyCode = null;

  if (!body) {
    // plain text node
    var _generate = generate(ast.children[0], {}),
        code = _generate.code;

    storyCode = "'".concat(code, "'");
  } else {
    if (body.type === 'JSXExpressionContainer') {
      // FIXME: handle fragments
      body = body.expression;
    }

    var _generate2 = generate(body, {}),
        _code = _generate2.code;

    storyCode = _code;
  }

  if (storyCode.trim().startsWith('() =>')) {
    statements.push("export const ".concat(storyKey, " = ").concat(storyCode));
  } else {
    statements.push("export const ".concat(storyKey, " = () => (\n        ").concat(storyCode, "\n      );"));
  }

  statements.push("".concat(storyKey, ".story = {};")); // always preserve the name, since CSF exports can get modified by displayName

  statements.push("".concat(storyKey, ".story.name = '").concat(storyName, "';"));
  var parameters = getAttr(ast.openingElement, 'parameters');
  parameters = parameters && parameters.expression;
  var source = jsStringEscape(storyCode);

  if (parameters) {
    var _generate3 = generate(parameters, {}),
        params = _generate3.code; // FIXME: hack in the story's source as a parameter


    statements.push("".concat(storyKey, ".story.parameters = { mdxSource: '").concat(source, "', ...").concat(params, " };"));
  } else {
    statements.push("".concat(storyKey, ".story.parameters = { mdxSource: '").concat(source, "' };"));
  }

  var decorators = getAttr(ast.openingElement, 'decorators');
  decorators = decorators && decorators.expression;

  if (decorators) {
    var _generate4 = generate(decorators, {}),
        decos = _generate4.code;

    statements.push("".concat(storyKey, ".story.decorators = ").concat(decos, ";"));
  } // eslint-disable-next-line no-param-reassign


  context.storyNameToKey[storyName] = storyKey;
  return _defineProperty({}, storyKey, statements.join('\n'));
}

function genPreviewExports(ast, context) {
  // console.log('genPreviewExports', JSON.stringify(ast, null, 2));
  var previewExports = {};

  for (var i = 0; i < ast.children.length; i += 1) {
    var child = ast.children[i];

    if (child.type === 'JSXElement' && child.openingElement.name.name === 'Story') {
      var storyExport = genStoryExport(child, context);

      if (storyExport) {
        Object.assign(previewExports, storyExport); // eslint-disable-next-line no-param-reassign

        context.counter += 1;
      }
    }
  }

  return previewExports;
}

function genMeta(ast) {
  var title = getAttr(ast.openingElement, 'title');
  var parameters = getAttr(ast.openingElement, 'parameters');
  var decorators = getAttr(ast.openingElement, 'decorators');
  title = title && "'".concat(title.value, "'");

  if (parameters && parameters.expression) {
    var _generate5 = generate(parameters.expression, {}),
        params = _generate5.code;

    parameters = params;
  }

  if (decorators && decorators.expression) {
    var _generate6 = generate(decorators.expression, {}),
        decos = _generate6.code;

    decorators = decos;
  }

  return {
    title: title,
    parameters: parameters,
    decorators: decorators
  };
}

function getExports(node, counter) {
  var value = node.value,
      type = node.type;

  if (type === 'jsx') {
    if (STORY_REGEX.exec(value)) {
      // Single story
      var ast = parser.parseExpression(value, {
        plugins: ['jsx']
      });
      var storyExport = genStoryExport(ast, counter);
      return storyExport && {
        stories: storyExport
      };
    }

    if (PREVIEW_REGEX.exec(value)) {
      // Preview, possibly containing multiple stories
      var _ast = parser.parseExpression(value, {
        plugins: ['jsx']
      });

      return {
        stories: genPreviewExports(_ast, counter)
      };
    }

    if (META_REGEX.exec(value)) {
      // Preview, possibly containing multiple stories
      var _ast2 = parser.parseExpression(value, {
        plugins: ['jsx']
      });

      return {
        meta: genMeta(_ast2)
      };
    }
  }

  return null;
} // insert `mdxKind` into the context so that we can know what "kind" we're rendering into
// when we render <Story name="xxx">...</Story>, since this MDX can be attached to any `selectedKind`!


var wrapperJs = "\ncomponentMeta.parameters = componentMeta.parameters || {};\ncomponentMeta.parameters.docs = {\n  container: ({ context, children }) => <DocsContainer context={{...context, mdxStoryNameToId}}>{children}</DocsContainer>,\n  page: MDXContent,\n};\n".trim(); // Use this rather than JSON.stringify because `Meta`'s attributes
// are already valid code strings, so we want to insert them raw
// rather than add an extra set of quotes

function stringifyMeta(meta) {
  var result = '{ ';
  Object.entries(meta).forEach(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        key = _ref3[0],
        val = _ref3[1];

    if (val) {
      result += "".concat(key, ": ").concat(val, ", ");
    }
  });
  result += ' }';
  return result;
}

function extractExports(node, options) {
  // we're overriding default export
  var defaultJsx = mdxToJsx.toJSX(node, {}, Object.assign({}, options, {
    skipExport: true
  }));
  var storyExports = [];
  var includeStories = [];
  var metaExport = null;
  var context = {
    counter: 0,
    storyNameToKey: {}
  };
  node.children.forEach(function (n) {
    var exports = getExports(n, context);

    if (exports) {
      var stories = exports.stories,
          meta = exports.meta;

      if (stories) {
        Object.entries(stories).forEach(function (_ref4) {
          var _ref5 = _slicedToArray(_ref4, 2),
              key = _ref5[0],
              story = _ref5[1];

          includeStories.push(key);
          storyExports.push(story);
        });
      }

      if (meta) {
        if (metaExport) {
          throw new Error('Meta can only be declared once');
        }

        metaExport = meta;
      }
    }
  });

  if (metaExport) {
    if (!storyExports.length) {
      storyExports.push('export const __page = () => { throw new Error("Docs-only story"); };');
      storyExports.push('__page.story = { parameters: { docsOnly: true } };');
      includeStories.push('__page');
    }
  } else {
    metaExport = {};
  }

  metaExport.includeStories = JSON.stringify(includeStories);
  var _metaExport = metaExport,
      title = _metaExport.title;
  var mdxStoryNameToId = Object.entries(context.storyNameToKey).reduce(function (acc, _ref6) {
    var _ref7 = _slicedToArray(_ref6, 2),
        storyName = _ref7[0],
        storyKey = _ref7[1];

    if (title) {
      acc[storyName] = toId(title, storyNameFromExport(storyKey));
    }

    return acc;
  }, {});
  var fullJsx = ['import { DocsContainer } from "@storybook/addon-docs/blocks";', defaultJsx].concat(storyExports, ["const componentMeta = ".concat(stringifyMeta(metaExport), ";"), "const mdxStoryNameToId = ".concat(JSON.stringify(mdxStoryNameToId), ";"), wrapperJs, 'export default componentMeta;']).join('\n\n');
  return fullJsx;
}

function createCompiler(mdxOptions) {
  return function compiler() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    this.Compiler = function (tree) {
      return extractExports(tree, options, mdxOptions);
    };
  };
}

module.exports = createCompiler;