import { Component } from 'react';
import PropTypes from 'prop-types';
import { KnobControlConfig, KnobControlProps } from './types';
export declare type RadiosTypeKnobValue = string | number | null | undefined;
export declare type RadiosTypeOptionsProp<T extends RadiosTypeKnobValue> = Record<string | number, T>;
export interface RadiosTypeKnob extends KnobControlConfig<RadiosTypeKnobValue> {
    options: RadiosTypeOptionsProp<RadiosTypeKnobValue>;
}
interface RadiosTypeProps extends KnobControlProps<RadiosTypeKnobValue>, RadiosWrapperProps {
    knob: RadiosTypeKnob;
}
interface RadiosWrapperProps {
    isInline: boolean;
}
declare class RadiosType extends Component<RadiosTypeProps> {
    static defaultProps: RadiosTypeProps;
    static propTypes: {
        knob: PropTypes.Validator<RadiosTypeKnob>;
        onChange: PropTypes.Validator<(value: string | number | null | undefined) => string | number | null | undefined>;
        isInline: PropTypes.Validator<boolean>;
    };
    static serialize: (value: string | number | null | undefined) => string | number | null | undefined;
    static deserialize: (value: string | number | null | undefined) => string | number | null | undefined;
    renderRadioButtonList({ options }: RadiosTypeKnob): JSX.Element[];
    renderRadioButton(label: string, value: RadiosTypeKnobValue): JSX.Element;
    render(): JSX.Element;
}
export default RadiosType;
