import * as React from 'react';
import { AnimatePropTypeInterface, CategoryPropType, ColorScalePropType, D3Scale, DomainPropType, DomainPaddingPropType, EventPropTypeInterface, PaddingProps, ScalePropType, StringOrNumberOrCallback, VictoryStyleInterface, VictoryStackProps } from 'victory';
import { ChartThemeDefinition } from '../ChartTheme';
/**
 * See https://github.com/DefinitelyTyped/DefinitelyTyped/blob/master/types/victory/index.d.ts
 */
export interface ChartStackProps extends VictoryStackProps {
    /**
     * The animate prop specifies props for VictoryAnimation to use.
     * The animate prop should also be used to specify enter and exit
     * transition configurations with the `onExit` and `onEnter` namespaces respectively.
     *
     * @example
     * {duration: 500, onExit: () => {}, onEnter: {duration: 500, before: () => ({y: 0})})}
     */
    animate?: AnimatePropTypeInterface;
    /**
     * The ariaDesc prop specifies the description of the chart/SVG to assist with
     * accessibility for screen readers.
     *
     * Note: Overridden by the desc prop of containerComponent
     */
    ariaDesc?: string;
    /**
     * The ariaTitle prop specifies the title to be applied to the SVG to assist
     * accessibility for screen readers.
     *
     * Note: Overridden by the title prop of containerComponent
     */
    ariaTitle?: string;
    /**
     * The categories prop specifies how categorical data for a chart should be ordered.
     * This prop should be given as an array of string values, or an object with
     * these values for x and y. When categories are not given as an object
     * When this prop is set on a wrapper component, it will dictate the categories of
     * its the children. If this prop is not set, any categories on child component
     * or catigorical data, will be merged to create a shared set of categories.
     *
     * @example ["dogs", "cats", "mice"]
     */
    categories?: CategoryPropType;
    /**
     * ChartStack works with any combination of the following children: ChartArea, ChartBar, VictoryCandlestick,
     * VictoryErrorBar, ChartGroup, ChartLine, VictoryScatter, ChartStack, and ChartVoronoi. Children supplied to
     * ChartGroup will be cloned and rendered with new props so that all children share common props such as domain and
     * scale.
     */
    children?: React.ReactNode;
    /**
     * The colorScale prop is an optional prop that defines the color scale the chart's bars
     * will be created on. This prop should be given as an array of CSS colors, or as a string
     * corresponding to one of the built in color scales. ChartStack will automatically assign
     * values from this color scale to the bars unless colors are explicitly provided in the
     * `dataAttributes` prop.
     */
    colorScale?: ColorScalePropType;
    /**
     * The containerComponent prop takes an entire component which will be used to
     * create a container element for standalone charts.
     * The new element created from the passed containerComponent wil be provided with
     * these props from ChartArea: height, width, children
     * (the chart itself) and style. Props that are not provided by the
     * child chart component include title and desc, both of which
     * are intended to add accessibility to Victory components. The more descriptive these props
     * are, the more accessible your data will be for people using screen readers.
     * Any of these props may be overridden by passing in props to the supplied component,
     * or modified or ignored within the custom component itself. If a dataComponent is
     * not provided, ChartArea will use the default ChartContainer component.
     *
     * @example <ChartContainer title="Chart of Dog Breeds" desc="This chart shows..." />
     */
    containerComponent?: React.ReactElement<any>;
    /**
     * The domain prop describes the range of values your chart will include. This prop can be
     * given as a array of the minimum and maximum expected values for your chart,
     * or as an object that specifies separate arrays for x and y.
     * If this prop is not provided, a domain will be calculated from data, or other
     * available information.
     *
     * @example [-1, 1], {x: [0, 100], y: [0, 1]}
     */
    domain?: DomainPropType;
    /**
     * The domainPadding prop specifies a number of pixels of padding to add to the
     * beginning and end of a domain. This prop is useful for explicitly spacing ticks farther
     * from the origin to prevent crowding. This prop should be given as an object with
     * numbers specified for x and y.
     */
    domainPadding?: DomainPaddingPropType;
    /**
     * Similar to data accessor props `x` and `y`, this prop may be used to functionally
     * assign eventKeys to data
     */
    eventKey?: StringOrNumberOrCallback;
    /**
     * The event prop take an array of event objects. Event objects are composed of
     * a childName, target, eventKey, and eventHandlers. Targets may be any valid style namespace
     * for a given component, (i.e. "data" and "labels"). The childName will refer to an
     * individual child of ChartStack, either by its name prop, or by index. The eventKey
     * may optionally be used to select a single element by index or eventKey rather than
     * an entire set. The eventHandlers object should be given as an object whose keys are standard
     * event names (i.e. onClick) and whose values are event callbacks. The return value
     * of an event handler is used to modify elemnts. The return value should be given
     * as an object or an array of objects with optional target and eventKey and childName keys,
     * and a mutation key whose value is a function. The target and eventKey and childName keys
     * will default to those corresponding to the element the event handler was attached to.
     * The mutation function will be called with the calculated props for the individual selected
     * element (i.e. a single bar), and the object returned from the mutation function
     * will override the props of the selected element via object assignment.
     *
     * @example
     * events={[
     *   {
     *     target: "data",
     *     childName: "firstBar",
     *     eventHandlers: {
     *       onClick: () => {
     *         return [
     *            {
     *              childName: "secondBar",
     *              mutation: (props) => {
     *                return {style: merge({}, props.style, {fill: "orange"})};
     *              }
     *            }, {
     *              childName: "secondBar",
     *              target: "labels",
     *              mutation: () => {
     *                return {text: "hey"};
     *              }
     *            }
     *          ];
     *       }
     *     }
     *   }
     * ]}
     */
    events?: EventPropTypeInterface<'data' | 'labels' | 'parent', StringOrNumberOrCallback>[];
    /**
     * ChartStack uses the standard externalEventMutations prop.
     */
    externalEventMutations?: any[];
    /**
     * The groupComponent prop takes an entire component which will be used to
     * create group elements for use within container elements. This prop defaults
     * to a <g> tag on web, and a react-native-svg <G> tag on mobile
     */
    groupComponent?: React.ReactElement<any>;
    /**
     * The height props specifies the height the svg viewBox of the chart container.
     * This value should be given as a number of pixels
     */
    height?: number;
    /**
     * The horizontal prop determines whether the bars will be laid vertically or
     * horizontally. The bars will be vertical if this prop is false or unspecified,
     * or horizontal if the prop is set to true.
     */
    horizontal?: boolean;
    /**
     * The labelComponent prop takes in an entire label component which will be used
     * to create a label for the area. The new element created from the passed labelComponent
     * will be supplied with the following properties: x, y, index, data, verticalAnchor,
     * textAnchor, angle, style, text, and events. any of these props may be overridden
     * by passing in props to the supplied component, or modified or ignored within
     * the custom component itself. If labelComponent is omitted, a new ChartLabel
     * will be created with props described above. This labelComponent prop should be used to
     * provide a series label for ChartArea. If individual labels are required for each
     * data point, they should be created by composing ChartArea with VictoryScatter
     */
    labelComponent?: React.ReactElement<any>;
    /**
     * The labels prop defines labels that will appear above each bar in your chart.
     * This prop should be given as an array of values or as a function of data.
     * If given as an array, the number of elements in the array should be equal to
     * the length of the data array. Labels may also be added directly to the data object
     * like data={[{x: 1, y: 1, label: "first"}]}.
     *
     * @example ["spring", "summer", "fall", "winter"], (datum) => datum.title
     */
    labels?: string[] | ((data: any) => string);
    /**
     * The maxDomain prop defines a maximum domain value for a chart. This prop is useful in situations where the maximum
     * domain of a chart is static, while the minimum value depends on data or other variable information. If the domain
     * prop is set in addition to maximumDomain, domain will be used.
     *
     * note: The x value supplied to the maxDomain prop refers to the independent variable, and the y value refers to the
     * dependent variable. This may cause confusion in horizontal charts, as the independent variable will corresponds to
     * the y axis.
     *
     * examples:
     *
     * maxDomain={0}
     * maxDomain={{ y: 0 }}
     */
    maxDomain?: number | {
        x?: number;
        y?: number;
    };
    /**
     * The minDomain prop defines a minimum domain value for a chart. This prop is useful in situations where the minimum
     * domain of a chart is static, while the maximum value depends on data or other variable information. If the domain
     * prop is set in addition to minimumDomain, domain will be used.
     *
     * note: The x value supplied to the minDomain prop refers to the independent variable, and the y value refers to the
     * dependent variable. This may cause confusion in horizontal charts, as the independent variable will corresponds to
     * the y axis.
     *
     * examples:
     *
     * minDomain={0}
     * minDomain={{ y: 0 }}
     */
    minDomain?: number | {
        x?: number;
        y?: number;
    };
    /**
     * The name prop is used to reference a component instance when defining shared events.
     */
    name?: string;
    /**
     * Victory components will pass an origin prop is to define the center point in svg coordinates for polar charts.
     * **This prop should not be set manually.**
     */
    origin?: {
        x: number;
        y: number;
    };
    /**
     * The padding props specifies the amount of padding in number of pixels between
     * the edge of the chart and any rendered child components. This prop can be given
     * as a number or as an object with padding specified for top, bottom, left
     * and right.
     */
    padding?: PaddingProps;
    /**
     * Victory components can pass a boolean polar prop to specify whether a label is part of a polar chart.
     * **This prop should not be set manually.**
     */
    polar?: boolean;
    /**
     * The range prop describes the dimensions over which data may be plotted. For cartesian coordinate systems, this
     * corresponds to minimum and maximum svg coordinates in the x and y dimension. In polar coordinate systems this
     * corresponds to a range of angles and radii. When this value is not given it will be calculated from the width,
     * height, and padding, or from the startAngle and endAngle in the case of polar charts. All components in a given
     * chart must share the same range, so setting this prop on children nested within Chart or
     * ChartGroup will have no effect. This prop is usually not set manually.
     *
     * examples:
     *
     * Cartesian: range={{ x: [50, 250], y: [50, 250] }}
     * Polar: range={{ x: [0, 360], y: [0, 250] }}
     */
    range?: [number, number] | {
        x?: [number, number];
        y?: [number, number];
    };
    /**
     * The scale prop determines which scales your chart should use. This prop can be
     * given as a string specifying a supported scale ("linear", "time", "log", "sqrt"),
     * as a d3 scale function, or as an object with scales specified for x and y
     *
     * @example d3Scale.time(), {x: "linear", y: "log"}
     */
    scale?: ScalePropType | D3Scale | {
        x?: ScalePropType | D3Scale;
        y?: ScalePropType | D3Scale;
    };
    /**
     * The sharedEvents prop is used internally to coordinate events between components. It should not be set manually.
     */
    sharedEvents?: any;
    /**
     * By default domainPadding is coerced to existing quadrants. This means that if a given domain only includes positive
     * values, no amount of padding applied by domainPadding will result in a domain with negative values. This is the
     * desired behavior in most cases. For users that need to apply padding without regard to quadrant, the
     * singleQuadrantDomainPadding prop may be used. This prop may be given as a boolean or an object with boolean values
     * specified for "x" and/or "y". When this prop is false (or false for a given dimension), padding will be applied
     * without regard to quadrant. If this prop is not specified, domainPadding will be coerced to existing quadrants.
     *
     * note: The x value supplied to the singleQuadrantDomainPadding prop refers to the independent variable, and the y
     * value refers to the dependent variable. This may cause confusion in horizontal charts, as the independent variable
     * will corresponds to the y axis.
     *
     * examples:
     *
     * singleQuadrantDomainPadding={false}
     * singleQuadrantDomainPadding={{ x: false }}
     */
    singleQuadrantDomainPadding?: boolean | {
        x: boolean;
        y: boolean;
    };
    /**
     * The standalone prop determines whether the component will render a standalone svg
     * or a <g> tag that will be included in an external svg. Set standalone to false to
     * compose ChartArea with other components within an enclosing <svg> tag.
     */
    standalone?: boolean;
    /**
     * The style prop specifies styles for your grouped chart. These styles will be
     * applied to all grouped children
     */
    style?: VictoryStyleInterface;
    /**
     * The theme prop takes a style object with nested data, labels, and parent objects.
     * You can create this object yourself, or you can use a theme provided by
     * When using ChartArea as a solo component, implement the theme directly on
     * ChartArea. If you are wrapping ChartArea in ChartChart or ChartGroup,
     * please call the theme on the outermost wrapper component instead.
     */
    theme?: ChartThemeDefinition;
    /**
     * Specifies the theme color. Valid values are 'blue', 'green', 'multi', etc.
     *
     * Note: Not compatible with theme prop
     *
     * @example themeColor={ChartThemeColor.blue}
     */
    themeColor?: string;
    /**
     * Specifies the theme variant. Valid values are 'dark' or 'light'
     *
     * Note: Not compatible with theme prop
     *
     * @example themeVariant={ChartThemeVariant.light}
     */
    themeVariant?: string;
    /**
     * The width props specifies the width of the svg viewBox of the chart container
     * This value should be given as a number of pixels
     */
    width?: number;
    /**
     * The xOffset prop is used for grouping stacks of bars. This prop will be set
     * by the ChartGroup component wrapper, or can be set manually.
     */
    xOffset?: number;
}
export declare const ChartStack: React.FunctionComponent<ChartStackProps>;
